ORCA/M Asm65816 2.1.0

0001 CB53              ****************************************************************
0002 CB53              *
0003 CB53              * Sound Tools
0004 CB53              *
0005 CB53              * Copyright Apple Computer, Inc.  1986-1989
0006 CB53              * All Rights Reserved
0007 CB53              *
0008 CB53              * This file implements the low level sound tool set.
0009 CB53              * It has one entry point, the SoundCallTable.
0010 CB53              *
0011 CB53              * Change History
0012 CB53              *
0013 CB53              * 09 Jun 88         Mike Askins and Steven Glass
0014 CB53              *
0015 CB53              * Code converted from EDASM to MAX
0016 CB53              *
0017 CB53              * 10 Jun 88         Steven Glass
0018 CB53              *
0019 CB53              * Call table made public.
0020 CB53              * Fill bytes removed at end of file.
0021 CB53              *
0022 CB53              *
0023 CB53              * 29 Jun 88         Matt Denman
0024 CB53              *
0025 CB53              * Added init of MidiInputPoll (makes it an RTL) in SBoot.
0026 CB53              *
0027 CB53              * 7 July 88         Matt Denman
0028 CB53              *
0029 CB53              * Deleted equ * at labels.  Hopefully my labels will be found now.
0030 CB53              *
0031 CB53              * 25 July 88        Matt Denman
0032 CB53              *
0033 CB53              * Deleted * seq statements and don't use code_bank equate any more.
0034 CB53              *
0035 CB53              *
0036 CB53              * 04 Aug 88         Steven Glass
0037 CB53              *
0038 CB53              * Removed all uses of the macro ToolCall and replace them with
0039 CB53              * the official macro.
0040 CB53              *
0041 CB53              * Fixed a number of attempts to push a long address on the
0042 CB53              * stack that was done with a pea SoundTools+2 instead of
0043 CB53              * using the PushLong macro.
0044 CB53              *
0045 CB53              * 12 Sept 88        Matt Denman
0046 CB53              *
0047 CB53              * Added three new calls.  FFSetUpSound, FFStartPlaying and FFSetUpParams.
0048 CB53              *
0049 CB53              * 13 March 89       Harry Yee
0050 CB53              *
0051 CB53              * Initialize the old MidiInputPoll vector ($E11DD8) to an RTL. We were
0052 CB53              * breaking some apps because the old Note Synthesizer and new sound tool
0053 CB53              * were not compatible. This old vector is used by the serial firmware
0054 CB53              * and gets initialized when the app gets ready to print. So initializing this
0055 CB53              * old vector does not hurt printing because this vector just gets reinitialized
0056 CB53              * when printing takes place. We just want to make these apps work as long
0057 CB53              * as possible (i.e. until printing takes place)
0058 CB53              *
0059 CB53              *
0060 CB53              * 2/7/90            Mark Cecys
0061 CB53              * BUG FIX: 'LastBlock' bit was not getting set when 'NextWave' is used. Fixed bug in
0062 CB53              * "ServeGen.aii".
0063 CB53              *
0064 CB53              ****************************************************************
0065 CB53                       print off 
0066 CB53                       include 'all.macros' 
0067 CB53                       include 'E16.MIDI' 
0068 CB53                       include 'snd.equ.aii' 
0069 CB53
0070 CB53                       TITLE 'Cortland Sound Firmware' 
0071 CB53                       EJECT 
0072 CB53                       import StartSound 
0073 CB53                       import SetupSound 
0074 CB53                       import serve_gen 
0075 CB53                       import fsynth_irq 
0076 CB53                       import illmode_error 
0077 CB53                       import SStartup 
0078 CB53                       import SStart_Stat 
0079 CB53                       import StopSound 
0080 CB53                       import Sound_Status 
0081 CB53                       import Gen_Stat 
0082 CB53                       import StartPlaying 
0083 CB53                       import SetUpParam 
0084 CB53                       import ReadParam 
0085 CB53
0086 CB53                       print on, nogen, nomdir, nohdr 
0087 CB53
0088 CB53
0089 CB53              SoundTools PROC 
0090 CB53
0091 CB53                       EJECT 
0092 CB53              ************************************************************
0093 CB53              *
0094 CB53              * the Sound Tools Function Pointer Table
0095 CB53              *
0096 CB53              ************************************************************
0097 CB53              *
0098 CB53                       Export SoundCallTable 
0099 CB53              SoundCallTable  
0100 CB53 19 00        STFPT    DC W:(EndSFPT-STFPT)/4
0101 CB55 00 00                 DC W:0                         ; for 32 bit count
0102 CB57 ED CB FC 00           DC L:SBoot-1                   ; 1: power-up init
0103 CB5B F6 CC FC 00           DC L:SStartup-1                ; 2: appl startup
0104 CB5F AA CD FC 00           DC L:SShutdn-1                 ; 3: appl shutdown
0105 CB63 C3 CD FC 00           DC L:STVer-1                   ; 4: return version info
0106 CB67 CE CD FC 00           DC L:SReset-1                  ; 5: Reset entry
0107 CB6B 90 D0 FC 00           DC L:sstart_stat-1             ; 6: tool status
0108 CB6F 24 CC FC 00           DC L:NotImp-1                  ; 7: reserved entry
0109 CB73 24 CC FC 00           DC L:NotImp-1                  ; 8: reserved entry
0110 CB77 12 CF FC 00           DC L:WriteEblock-1             ; 9: move data from RAM to SRAM
0111 CB7B C0 CE FC 00           DC L:ReadEblock-1              ; A: move data from SRAM to RAM
0112 CB7F DB CD FC 00           DC L:EntryVect-1               ; B: return entry table address
0113 CB83 89 CF FC 00           DC L:GetVolume-1               ; C: Get a volume level
0114 CB87 60 CF FC 00           DC L:SetVolume-1               ; D: Set a volume level
0115 CB8B 68 D1 FC 00           DC L:StartSound-1              ; E: start sounding
0116 CB8F C8 CF FC 00           DC L:StopSound-1               ; F: stop sounding
0117 CB93 A2 D0 FC 00           DC L:sound_status-1            ; 10: active generators word
0118 CB97 AE D0 FC 00           DC L:Gen_stat-1                ; 11: generator busy?
0119 CB9B E9 D0 FC 00           DC L:Smirq-1                   ; 12: set sound interrupt vector
0120 CB9F 1B D1 FC 00           DC L:suirq-1                   ; 13 set user synthesizer vector
0121 CBA3 5B D6 FC 00           DC L:gen_ctrl_bytes-1          ; 14 read generator control bytes
0122 CBA7 58 D1 FC 00           DC L:SetUpSound-1              ; 15 same as soundstart but doesn't start the gen.
0123 CBAB F9 D1 FC 00           DC L:StartPlaying-1            ; 16 Start specified generators running.
0124 CBAF 72 D2 FC 00           DC L:SetUpParam-1              ; 17 Set first two byte of GCB and doc reg as spec.
0125 CBB3 67 D2 FC 00           DC L:ReadParam-1               ; 18 Read the DocRam into paramater block.
0126 CBB7              ;           Ram based sound tools go here
0127 CBB7              ;
0128 CBB7              ;
0129 CBB7              EndSFPT                                 ; 
0130 CBB7                       EJECT 
0131 CBB7
0132 CBB7
0133 CBB7                       TITLE 'End call routine' 
0134 CBB7                       EJECT 
0135 CBB7              ********************************************************
0136 CBB7              *
0137 CBB7              * Endcall: This routine will move 6 bytes (2 RTL addresses) up the
0138 CBB7              *          stack.  This call will preserve the Direct register and
0139 CBB7              *          accumulator.
0140 CBB7              *
0141 CBB7              *     Import:
0142 CBB7              *            A = error code
0143 CBB7              *            P = status flag
0144 CBB7              *            X = number of BYTES to strip
0145 CBB7              *
0146 CBB7              *     Export:
0147 CBB7              *            A = error code
0148 CBB7              *            P = status flag
0149 CBB7              *
0150 CBB7              ********************************************************
0151 CBB7              ;
0152 CBB7              ;
0153 CBB7                       LONGA ON                       ;
0154 CBB7                       LONGI ON                       ;
0155 CBB7              Endcall                                 ;
0156 CBB7 2B                    pld                            ; restore direct register
0157 CBB8              Oendcall                                ; endcall w/o restore dir. reg
0158 CBB8 A2 00 00              ldx   #$0000                   ; successful call
0159 CBBB 80 01                 bra   oerrout                  ;
0160 CBBD              Errout                                  ;
0161 CBBD 2B                    pld                            ;
0162 CBBE              oerrout                                 ;
0163 CBBE 98                    tya                            ; save the byte count
0164 CBBF 9B                    txy                            ; save error code
0165 CBC0 AA                    tax                            ; get the count back
0166 CBC1 E0 00 00              cpx   #$0000                   ; check for no movement
0167 CBC4 F0 1E                 beq   no_games                 ; nothing to move
0168 CBC6 08                    php                            ; save the micro status
0169 CBC7 0B                    phd                            ; save direct register
0170 CBC8 3B                    tsc                            ; get stack pointer
0171 CBC9 48                    pha                            ; set new direct register
0172 CBCA 2B                    pld                            ;
0173 CBCB A3 08                 lda   $08,s                    ; get a word 1 off the stack
0174 CBCD 95 08                 sta   $08,x                    ; move it up x number of bytes
0175 CBCF A3 06                 lda   $06,s                    ; get word 2 off the stack
0176 CBD1 95 06                 sta   $06,x                    ; move it up x number of bytes
0177 CBD3 A3 04                 lda   $04,s                    ; get word three of the stack
0178 CBD5 95 04                 sta   $04,x                    ; move it up x number of bytes
0179 CBD7 3B                    tsc                            ; save stack ptr position
0180 CBD8 83 04                 sta   $04,s                    ;
0181 CBDA 8A                    txa                            ; get the byte count
0182 CBDB 18                    clc                            ; calculate new stack pointer
0183 CBDC 63 04                 adc   $04,s                    ; new stack pointer
0184 CBDE 69 03 00              adc   #$0003                   ; skip stat. & direct register
0185 CBE1 2B                    pld                            ; restore direct register
0186 CBE2 28                    plp                            ; restore status register
0187 CBE3 1B                    tcs                            ; point to new stack location
0188 CBE4              no_games                                ;
0189 CBE4 98                    tya                            ; restore error code
0190 CBE5 C9 01 00              cmp   #$01                     ; set carry if an error
0191 CBE8 90 03                 bcc   @1                       ; everybody happy
0192 CBEA 09 00 08              ora   #sound_tool*256
0193 CBED              @1                                      ;
0194 CBED 6B                    rtl                            ; >>>--- exit endcall --->>>
0195 CBEE              ;
0196 CBEE              ;
0197 CBEE              ************************************************************
0198 CBEE              *
0199 CBEE              * SBoot is system power-up entry.
0200 CBEE              * It erases the 64K SRAM to all $80 (the DAC Midval)
0201 CBEE              * and inits the DOC registers
0202 CBEE              *
0203 CBEE              *
0204 CBEE              * Change History
0205 CBEE              *
0206 CBEE              * 29 Jun 88         Matt Dennman
0207 CBEE              *
0208 CBEE              * Added init of MidiInputPoll (makes it an RTL)
0209 CBEE              *
0210 CBEE              ************************************************************
0211 CBEE              *
0212 CBEE              Sboot                                   ;
0213 CBEE 08                    php                            ; no interruptions
0214 CBEF 78                    sei                            ;
0215 CBF0
0216 CBF0 A9 6B 00              lda   #$6B                     ; RTL
0217 CBF3 8F B2 01 E1           sta   MidiInputPoll
0218 CBF7 8F D8 1D E1           sta   >$E11DD8
0219 CBFB
0220 CBFB 20 9D CE              jsr   wipe_doc_ram             ; set doc ram to $80s
0221 CBFE A2 1F 00     sboot_1  ldx   #sram_size               ; number of sound ram locations
0222 CC01 A9 00 00              lda   #$0000                   ; reset number of active oscillators
0223 CC04                       LONGA OFF
0224 CC04 E2 20                 sep   #$20                     ; 8-bit AC
0225 CC06 9F B0 1D E1  sram_zap_loop sta   >sram_base+sram_start,x ; clear work ram
0226 CC0A CA                    dex                            ; decrement count
0227 CC0B 10 F9                 bpl   sram_zap_loop            ; keep going until all zeroed
0228 CC0D AF CA 00 E1           lda   >irq_volume              ; get the system
0229 CC11 0A                    asl   A                        ; convert to 8 bit form
0230 CC12 0A                    asl   A                        ;
0231 CC13 0A                    asl   A                        ;
0232 CC14 0A                    asl   A                        ;
0233 CC15 8F B0 1D E1           sta   >sram_base+sysvolloc     ; save it away
0234 CC19 AF D6 00 E1           lda   >DOCFlag                 ; check if DOC installed
0235 CC1D D0 03                 bne   @1                       ; if not, clear M-bit and exit
0236 CC1F 20 2B CC              jsr   InitDoc                  ; initialize the DOC chip
0237 CC22              @1                                      ;
0238 CC22 28                    plp                            ; m, x & irq status
0239 CC23 C2 20        Exit0M   rep   #$20                     ; reset M-bit
0240 CC25              notimp                                  ;
0241 CC25 A0 00 00              ldy   #0
0242 CC28 4C B8 CB              jmp   Oendcall
0243 CC2B              *
0244 CC2B              * DOC is present so init it
0245 CC2B              *
0246 CC2B A9 20        InitDOC  lda   #GPtrInc+GRegSel         ; setup to acc regs and increment
0247 CC2D 0F CA 00 E1           ora   >IRQ_Volume              ; get 4-bit sysvol image
0248 CC31 8F 3C C0 E1           sta   >GStatReg                ; and setup the GLU
0249 CC35 A9 E1                 lda   #EOEnb                   ; osc enable reg
0250 CC37 8F 3E C0 E1           sta   >Gadrl
0251 CC3B A9 3E                 lda   #62                      ; 32 oscs
0252 CC3D 8F 3D C0 E1           sta   >GDatReg
0253 CC41 20 7A CC              jsr   StopDOC                  ; all vols to 0, all osc off
0254 CC44                       LONGA ON                       ;
0255 CC44 C2 20                 rep   #$20                     ;
0256 CC46 A9 62 CD              lda   #illmode_error           ; apple snd vector
0257 CC49 8F 49 01 E1           sta   >asnd_vect+1             ;
0258 CC4D 8F BE 1D E1           sta   >sram_base+user_irq_vect ;
0259 CC51                       LONGA OFF                      ;
0260 CC51 E2 20                 sep   #$20                     ;
0261 CC53 A9 FC                 lda   #^SoundTools             ; point to our code bank
0262 CC55 8F 4B 01 E1           sta   >asnd_vect+3             ;
0263 CC59 8F C0 1D E1           sta   >sram_base+user_irq_vect+2 ;
0264 CC5D A9 5C                 lda   #$5C                     ; we get to the users vector through a JMP long
0265 CC5F 8F 48 01 E1           sta   >asnd_vect               ;
0266 CC63 8F BD 1D E1           sta   >sram_base+user_irq      ;
0267 CC67                       LONGA ON                       ; 16 bit accum, memory
0268 CC67 C2 20                 rep   #$20                     ;
0269 CC69 F4 0B 00              pea   sound_vect_ref           ; sound vector ref. number
0270 CC6C F4 FC 00 F4           PushLong  #illmode_error       ; invalid sound interrupt
0271 CC72 A2 03 10 22           _SetVector 
0272 CC79 60                    rts                            ; >>>--- exit InitDoc --->>>
0273 CC7A              *
0274 CC7A              * Stop all DOC oscs, set all Vols to 0, and clear sound-on flag
0275 CC7A              *
0276 CC7A              * Called w/ M=1, X=0
0277 CC7A              *
0278 CC7A                       LONGA OFF                      ;
0279 CC7A              stopdoc                                 ;
0280 CC7A 08                    php                            ;
0281 CC7B 78                    sei                            ; no interruptions
0282 CC7C A9 20                 lda   #GPtrInc+GRegSel
0283 CC7E 0F CA 00 E1           ora   >IRQ_Volume
0284 CC82 8F 3C C0 E1           sta   >GStatReg                ; setup for register access
0285 CC86 A9 20                 lda   #EFreqhi                 ;
0286 CC88 8F 3E C0 E1           sta   >Gadrl
0287 CC8C A9 00                 lda   #$00                     ;
0288 CC8E 20 EC CC              jsr   Fill32                   ; stop all oscs
0289 CC91 A9 00                 lda   #EFreqlo                 ; point set the freq to zero
0290 CC93 8F 3E C0 E1           sta   >Gadrl
0291 CC97 A9 00                 lda   #00                      ;
0292 CC99 20 EC CC              jsr   Fill32                   ;
0293 CC9C A9 40                 lda   #EVol
0294 CC9E 8F 3E C0 E1           sta   >GAdrl                   ; point to VolReg0
0295 CCA2 A9 00                 lda   #0
0296 CCA4 8F B1 1D E1           sta   >sram_base+SoundOn       ; clear the sound playing flag
0297 CCA8 20 EC CC              jsr   Fill32                   ; set all Vols=0
0298 CCAB A9 80                 lda   #EwavPage                ; point to DOC ram page $0000
0299 CCAD 8F 3E C0 E1           sta   >Gadrl
0300 CCB1 A9 00                 lda   #00                      ;
0301 CCB3 20 EC CC              jsr   Fill32                   ; stop all oscs
0302 CCB6 A9 C0                 lda   #EBTR                    ; size & resolution = $0000
0303 CCB8 8F 3E C0 E1           sta   >Gadrl
0304 CCBC A9 00                 lda   #00                      ;
0305 CCBE 20 EC CC              jsr   Fill32                   ; all oscs
0306 CCC1 A9 A0                 lda   #EOCR                    ; halt all oscillators, no IRQ
0307 CCC3 8F 3E C0 E1           sta   >Gadrl
0308 CCC7 A9 01                 lda   #EOCRHlt                 ; halt, interrupts off
0309 CCC9 20 EC CC              jsr   Fill32                   ; stop all oscs
0310 CCCC AF CA 00 E1           lda   >Irq_volume              ; get the system volume
0311 CCD0 29 0F                 and   #$0F                     ; select doc no auto incr.
0312 CCD2 8F 3C C0 E1           sta   >Gstatreg                ;write to sound glu control
0313 CCD6 A9 E0                 lda   #eoir                    ; point to Ensoniq irq register
0314 CCD8 8F 3E C0 E1           sta   >Gadrl                   ;
0315 CCDC AF 3D C0 E1           lda   >Gdatreg                 ; dummy read
0316 CCE0 A2 22 00              ldx   #$22                     ; 34 times
0317 CCE3 AF 3D C0 E1  stopdoc_2 lda   >Gdatreg                ; read irq status
0318 CCE7 CA                    dex                            ; decrement count
0319 CCE8 D0 F9                 bne   stopdoc_2                ; 34 times
0320 CCEA 28                    plp                            ;
0321 CCEB 60                    rts   
0322 CCEC              *
0323 CCEC              * Fill the 32 registers pointed to by the GLU with the
0324 CCEC              * 8-bit value in the A-reg
0325 CCEC              *
0326 CCEC              * called w/ M=1, X=0
0327 CCEC              *
0328 CCEC A2 20 00     Fill32   ldx   #$20
0329 CCEF 8F 3D C0 E1  F32a     sta   >GDatReg                 ; write to a register
0330 CCF3 CA                    dex   
0331 CCF4 D0 F9                 bne   F32a
0332 CCF6 60                    rts   
0333 CCF7                       LONGA ON                       ;
0334 CCF7
0335 CCF7
0336 CCF7              ************************************************************
0337 CCF7              *
0338 CCF7              * SStartup Tool inits the Sound Tool set its WAP. It Does
0339 CCF7              * a SShutDown first if necessary.
0340 CCF7              *
0341 CCF7              *   Called: push DirectPageAdr
0342 CCF7              *           _SoundStartup
0343 CCF7              *
0344 CCF7              *  Returns: error if DOC not installed
0345 CCF7              *
0346 CCF7              ************************************************************
0347 CCF7
0348 CCF7              SStartup                                ;
0349 CCF7 AF D6 00 E1           lda   >DOCFlag                 ; is DOC installed?
0350 CCFB 29 FF 00              and   #$FF                     ; for low-byte only
0351 CCFE F0 09                 beq   SSt1                     ; yes, go on
0352 CD00 A2 10 00              ldx   #NoDOCErr                ; get error message
0353 CD03 A0 02 00              ldy   #2                       ;
0354 CD06 4C BE CB              jmp   oerrout                  ;
0355 CD09              SSt1                                    ;
0356 CD09 20 A2 CD              jsr   SStartChk                ; are we already started?
0357 CD0C F0 0B                 beq   SSt2                     ; no, we're shut down
0358 CD0E A2 18 00              ldx   #start_err               ; startup error
0359 CD11 A0 02 00              ldy   #2                       ;
0360 CD14 4C BE CB              jmp   oerrout                  ;
0361 CD17                       LONGA ON                       ;
0362 CD17 C2 20                 rep   #$20                     ;
0363 CD19 A3 07        SSt2     lda   W1,S                     ; get the passed direct page addr.
0364 CD1B 8F B7 1D E1           sta   >sram_base+wap_addr      ; save the zero page pointer
0365 CD1F F4 00 00 F4           SetWAP 0,MyToolNum 
0366 CD30 0B                    phd                            ; save current direct register
0367 CD31 AF B7 1D E1           lda   >sram_base+wap_addr      ; get our work zero page
0368 CD35 5B                    tcd                            ; save our zero page
0369 CD36 A2 FA 00              ldx   #zpg_size-1              ; clear zero page work area
0370 CD39                       LONGA OFF                      ;
0371 CD39 E2 20                 sep   #$20                     ;
0372 CD3B A9 00                 lda   #00                      ;
0373 CD3D              zpg_zap_loop                            ;
0374 CD3D 95 00                 sta   gcb_tbl,x                ;
0375 CD3F CA                    dex                            ;
0376 CD40 10 FB                 bpl   zpg_zap_loop             ;
0377 CD42 2B                    pld                            ; restore zero page
0378 CD43 A9 FF                 lda   #$FF                     ; set the wap initialized flag
0379 CD45 8F B6 1D E1           sta   >sram_base+wap_installed
0380 CD49 8F C1 1D E1           sta   >sram_base+start_stat    ; mark startup call made status
0381 CD4D                       LONGA ON
0382 CD4D C2 20                 rep   #$20                     ;
0383 CD4F F4 FC 00 F4           PushLong #fsynth_irq           ; address of sound interrupt handler
0384 CD55 A2 08 12 22           _SetSoundMIRQV 
0385 CD5C A0 02 00              ldy   #2
0386 CD5F 4C B8 CB              jmp   Oendcall
0387 CD62
0388 CD62
0389 CD62              illmode_error  
0390 CD62                                                      ; default user irq vector routine
0391 CD62 C2 30                 rep   #$30
0392 CD64 F4 FF 08              pea   sound_tool*256+uncsndirq ; unclaimed snd irq
0393 CD67                                                      ; NOTE: Will never come back!
0394 CD67 F4 FC 00 F4           PushLong #unc_snd_irq          ; unclaimed sound irq
0395 CD6D A2 03 15 22           _SysFailMgr 
0396 CD74
0397 CD74 2D 00        unc_snd_irq DC W:unirq_siz              ; unclaimed irq size
0398 CD76 0D 00                 DC W:$0D                       ; 5 lines down
0399 CD78 0A 00                 DC W:$0A                       ;
0400 CD7A 0A 00                 DC W:$0A                       ;
0401 CD7C 0A 00                 DC W:$0A                       ;
0402 CD7E 0A 00                 DC W:$0A                       ;
0403 CD80 0A 00                 DC W:$0A                       ;
0404 CD82 20 20 20 20           DC B:'      Unclaimed Sound Interrupt '
0405 CDA2
0406 CDA2              unirq_siz equ   *-unc_snd_irq-1         ; string size
0407 CDA2
0408 CDA2              *
0409 CDA2              * Test if wap assigned
0410 CDA2              *
0411 CDA2                       LONGA OFF                      ;
0412 CDA2                       LONGI ON                       ;
0413 CDA2              SStartChk                               ;
0414 CDA2 E2 20                 sep   #$20                     ;
0415 CDA4 AF B6 1D E1           lda   >sram_base+wap_installed ; wap installed?
0416 CDA8 C2 20                 rep   #$20                     ;
0417 CDAA 60           SSOK     rts   
0418 CDAB
0419 CDAB
0420 CDAB              ************************************************************
0421 CDAB              *
0422 CDAB              * SShutDown stops all sound, kills sound interrupts,
0423 CDAB              * and resets our WAP to zero
0424 CDAB              *
0425 CDAB              *
0426 CDAB              *   Called SoundShutdown
0427 CDAB              *  Returns No Error
0428 CDAB              *
0429 CDAB              ************************************************************
0430 CDAB              *
0431 CDAB              sshutdn                                 ;
0432 CDAB                       LONGA ON                       ;
0433 CDAB                       LONGI ON                       ;
0434 CDAB 08                    php                            ; save interrupt bit
0435 CDAC 78                    sei                            ; no interruptions
0436 CDAD A9 00 00              lda   #0
0437 CDB0 F4 00 00 F4           SetWAP 0,MyToolNum 
0438 CDC1 82 3A FE              brl   Sboot_1                  ; shut down rest of system
0439 CDC4
0440 CDC4
0441 CDC4
0442 CDC4              ************************************************************
0443 CDC4              *
0444 CDC4              * Version number tool returns the current Sound Tool
0445 CDC4              * version #.
0446 CDC4              *
0447 CDC4              *    Called:  pea 0 ; return value placeholder
0448 CDC4              *             SoundVersion
0449 CDC4              *
0450 CDC4              * Returns: X,Y unchanged.  Version on stack
0451 CDC4              *
0452 CDC4              ************************************************************
0453 CDC4
0454 CDC4
0455 CDC4
0456 CDC4 A9 00 03     STVer    lda   #Version                 ; get version #
0457 CDC7 83 07                 sta   W1,s                     ; place in stack
0458 CDC9 A0 00 00              ldy   #0
0459 CDCC 4C B8 CB              jmp   Oendcall
0460 CDCF
0461 CDCF
0462 CDCF
0463 CDCF              ************************************************************
0464 CDCF              *
0465 CDCF              * SReset Tool simply stops all sound and sound interrupts
0466 CDCF              *
0467 CDCF              *  Called:  SoundReset
0468 CDCF              * Returns:  No error
0469 CDCF              *
0470 CDCF              ************************************************************
0471 CDCF              *
0472 CDCF E2 20        SReset   sep   #$20                     ; M=1
0473 CDD1 20 7A CC              jsr   StopDOC                  ; stop all activity
0474 CDD4 C2 20                 rep   #$20                     ; M=0
0475 CDD6 A0 00 00              ldy   #0
0476 CDD9 4C B8 CB              jmp   Oendcall
0477 CDDC
0478 CDDC
0479 CDDC
0480 CDDC              ************************************************************
0481 CDDC              *
0482 CDDC              * EntryVect tool returns the address of the entry-vector
0483 CDDC              * and utility address table.
0484 CDDC              *
0485 CDDC              * called:  pea $0
0486 CDDC              *          pea $0 ; 32 bit placeholder
0487 CDDC              *          _GetTableAddress
0488 CDDC              *
0489 CDDC              * returns: 32-bit address of utility address table
0490 CDDC              *
0491 CDDC              ************************************************************
0492 CDDC              *
0493 CDDC A9 E9 CD     EntryVect lda   #EntryTabl
0494 CDDF 83 07                 sta   W1,s                     ; insert in stack placeholder
0495 CDE1 A9 FC 00              lda   #^EntryTabl
0496 CDE4 83 09                 sta   W2,S
0497 CDE6 4C 23 CC              jmp   Exit0M                   ; clr M-bit and exitt
0498 CDE9                       EJECT 
0499 CDE9              ************************************************************
0500 CDE9              *
0501 CDE9              * The Entry table for fast access to the sound utilities.
0502 CDE9              *
0503 CDE9              * Th address of this table is passed back by the Sound Tools
0504 CDE9              * "EntryVect" function.
0505 CDE9              *
0506 CDE9              ************************************************************
0507 CDE9
0508 CDE9
0509 CDE9 11 CE FC 00  EntryTabl DC L:RdSReg
0510 CDED 22 CE FC 00           DC L:WrtSReg
0511 CDF1 16 CE FC 00           DC L:RdSRAM
0512 CDF5 27 CE FC 00           DC L:WrtSRAM
0513 CDF9 1D CE FC 00           DC L:RdSNxt
0514 CDFD 2A CE FC 00           DC L:WrtSNxt
0515 CE01 5E CE FC 00           DC L:osctable
0516 CE05 6E CE FC 00           DC L:gentable
0517 CE09 8E CE FC 00           DC L:gcb_xlate
0518 CE0D 4F CE FC 00           DC L:dis_incr
0519 CE11                       EJECT 
0520 CE11              ************************************************************
0521 CE11              *
0522 CE11              * Low level entry calls to access individual DOC
0523 CE11              * registers and RAM locations.
0524 CE11              *
0525 CE11              * All entered in Native mode with M=1 and X=0.
0526 CE11              *
0527 CE11              ************************************************************
0528 CE11
0529 CE11
0530 CE11
0531 CE11                       LONGA OFF                      ;
0532 CE11              rdsreg                                  ;
0533 CE11 20 3D CE              jsr   AccSReg                  ; setup to access registers
0534 CE14 80 03                 bra   SRead                    ; and read it
0535 CE16              *
0536 CE16              rdsram                                  ;
0537 CE16 20 2F CE              jsr   AccSRAM                  ; setup to acces sound RAM
0538 CE19              sread                                   ;
0539 CE19 AF 3D C0 E1           lda   >GDatReg                 ; a dummy read to prime the SGlu
0540 CE1D              rdsnxt                                  ;
0541 CE1D AF 3D C0 E1           lda   >GDatReg                 ; get the data
0542 CE21 6B                    rtl                            ; and get out
0543 CE22              *
0544 CE22              wrtsreg                                 ;
0545 CE22 20 3D CE              jsr   AccSReg                  ; setup to access registers
0546 CE25 80 03                 bra   WrtSNxt
0547 CE27              *
0548 CE27              wrtsram                                 ;
0549 CE27 20 2F CE              jsr   AccSRAM                  ; setup to acces SRAM
0550 CE2A              wrtsnxt                                 ;
0551 CE2A 8F 3D C0 E1           sta   >GDatReg                 ; write the data
0552 CE2E 6B                    rtl                            ; and return
0553 CE2F              *
0554 CE2F              accsram                                 ;
0555 CE2F 48                    pha                            ; save the AC
0556 CE30                       LONGA ON
0557 CE30 C2 20                 rep   #$20                     ;
0558 CE32 8A                    txa                            ; get reg/addr
0559 CE33 8F 3E C0 E1           sta   gadrl                    ; save reg/addr value
0560 CE37                       LONGA OFF                      ;
0561 CE37 E2 20                 sep   #$20                     ; 8 bit accumulator
0562 CE39 A9 60                 lda   #GPtrInc+GRAMSel         ; access RAM and increment
0563 CE3B 80 08                 bra   acc1
0564 CE3D              accsreg                                 ;
0565 CE3D 48                    pha   
0566 CE3E 8A                    txa                            ; get reg/addr
0567 CE3F 8F 3E C0 E1           sta   gadrl                    ; point to reg/addr
0568 CE43 A9 20                 lda   #GPtrInc                 ; access registers and increment
0569 CE45              acc1                                    ;
0570 CE45 0F CA 00 E1           ora   >IRQ_Volume              ; or in volume 4-lsbs
0571 CE49 8F 3C C0 E1           sta   >GStatReg                ; and set the glue status register
0572 CE4D 68                    pla                            ; restore the AC
0573 CE4E 60                    rts   
0574 CE4F              ;
0575 CE4F              dis_incr                                ;
0576 CE4F AF 3C C0 E1           lda   >gstatreg                ; read the sound glu control
0577 CE53 29 D0                 and   #$D0                     ; mask off sys vol & auto incr
0578 CE55 0F CA 00 E1           ora   >IRQ_Volume              ; or in volume 4-lsbs
0579 CE59 8F 3C C0 E1           sta   >GStatReg                ; and set the glue status register
0580 CE5D 6B                    rtl                            ; >>>--- exit dis.incr --->>>
0581 CE5E              ;
0582 CE5E              ;
0583 CE5E              *
0584 CE5E              * Satisfy assembler to prevent errors
0585 CE5E              *
0586 CE5E              RateTable  
0587 CE5E              SetupGen equ   NotImp
0588 CE5E              Note     equ   NotImp
0589 CE5E              SIntRate equ   NotImp
0590 CE5E              Octavetable  
0591 CE5E              NoteTable  
0592 CE5E              *
0593 CE5E              *
0594 CE5E
0595 CE5E                       TITLE 'Oscillator table' 
0596 CE5E                       EJECT 
0597 CE5E              ************************************************************
0598 CE5E              *
0599 CE5E              * Table of Physical DOC oscillator #'s indexed by
0600 CE5E              * the logical Sound generator number (0-f)
0601 CE5E              *
0602 CE5E              * Entries point to the first osc of each osc-pair
0603 CE5E              * used as a sound generator
0604 CE5E              *
0605 CE5E              ************************************************************
0606 CE5E                       export Osctable 
0607 CE5E              Osctable                                ;
0608 CE5E 00 10 08 18           DC B:$00,$10,$08,$18
0609 CE62 04 14 0C 1C           DC B:$04,$14,$0C,$1C
0610 CE66 02 12 0A 1A           DC B:$02,$12,$0A,$1A
0611 CE6A 06 16 0E 1E           DC B:$06,$16,$0E,$1E
0612 CE6E              ;
0613 CE6E              ;
0614 CE6E                       TITLE 'Generator table' 
0615 CE6E                       EJECT 
0616 CE6E              ************************************************************
0617 CE6E              *
0618 CE6E              * Gen.table: Table of Physical sound generator #'s indexed by
0619 CE6E              *            the DOC oscillator number $00-$1F.
0620 CE6E              *            Entries point to generator number for that pair of oscs.
0621 CE6E              *
0622 CE6E              ************************************************************
0623 CE6E                       export Gentable 
0624 CE6E              Gentable                                ;
0625 CE6E 00 00                 DC B:$00,$00                   ; osc # $00,$01
0626 CE70 08 08                 DC B:$08,$08                   ; osc # $02,$03
0627 CE72 04 04                 DC B:$04,$04                   ; osc # $04,$05
0628 CE74 0C 0C                 DC B:$0C,$0C                   ; osc # $06,$07
0629 CE76 02 02                 DC B:$02,$02                   ; osc # $08,$09
0630 CE78 0A 0A                 DC B:$0A,$0A                   ; osc # $0A,$0B
0631 CE7A 06 06                 DC B:$06,$06                   ; osc # $0C,$0D
0632 CE7C 0E 0E                 DC B:$0E,$0E                   ; osc # $0E,$0F
0633 CE7E 01 01                 DC B:$01,$01                   ; osc # $10,$11
0634 CE80 09 09                 DC B:$09,$09                   ; osc # $12,$13
0635 CE82 05 05                 DC B:$05,$05                   ; osc # $14,$15
0636 CE84 0D 0D                 DC B:$0D,$0D                   ; osc # $16,$17
0637 CE86 03 03                 DC B:$03,$03                   ; osc # $18,$19
0638 CE88 0B 0B                 DC B:$0B,$0B                   ; osc # $1A,$1B
0639 CE8A 07 07                 DC B:$07,$07                   ; osc # $1C,$1D
0640 CE8C 0F 0F                 DC B:$0F,$0F                   ; osc # $1E,$1F
0641 CE8E              ;
0642 CE8E              ;
0643 CE8E                       TITLE 'Gen # to gcg addr table' 
0644 CE8E                       EJECT 
0645 CE8E              ********************************************************
0646 CE8E              *
0647 CE8E              * gcb.xlate: This table translates the gen number into a gcb entry
0648 CE8E              *            address.
0649 CE8E              *
0650 CE8E              *     Import: X = generator number
0651 CE8E              *
0652 CE8E              *     Export: X = gcb start addr corresponding to gen #
0653 CE8E              *
0654 CE8E              ********************************************************
0655 CE8E              ;
0656 CE8E              ;
0657 CE8E                       export gcb_xlate 
0658 CE8E              gcb_xlate                               ;
0659 CE8E 00                    DC B:gen0_gcb                  ;
0660 CE8F 10                    DC B:gen1_gcb                  ;
0661 CE90 20                    DC B:gen2_gcb                  ;
0662 CE91 30                    DC B:gen3_gcb                  ;
0663 CE92 40                    DC B:gen4_gcb                  ;
0664 CE93 50                    DC B:gen5_gcb                  ;
0665 CE94 60                    DC B:gen6_gcb                  ;
0666 CE95 70                    DC B:gen7_gcb                  ;
0667 CE96 80                    DC B:gen8_gcb                  ;
0668 CE97 90                    DC B:gen9_gcb                  ;
0669 CE98 A0                    DC B:genA_gcb                  ;
0670 CE99 B0                    DC B:genB_gcb                  ;
0671 CE9A C0                    DC B:genC_gcb                  ;
0672 CE9B D0                    DC B:genD_gcb                  ;
0673 CE9C E0                    DC B:genE_gcb                  ;
0674 CE9D
0675 CE9D              ;
0676 CE9D              ;
0677 CE9D                       TITLE 'Set doc ram to $80s' 
0678 CE9D                       EJECT 
0679 CE9D              ********************************************************
0680 CE9D              *
0681 CE9D              * Wipe.doc.ram: This routine will fill all of the Doc ram to $80
0682 CE9D              *
0683 CE9D              ********************************************************
0684 CE9D              ;
0685 CE9D              ;
0686 CE9D              wipe_doc_ram                            ;
0687 CE9D                       LONGA OFF                      ;
0688 CE9D                       LONGI OFF                      ;
0689 CE9D E2 20                 sep   #$20                     ;
0690 CE9F C2 10                 rep   #$10                     ;
0691 CEA1 A9 00                 lda   #0                       ;
0692 CEA3 8F 3E C0 E1           sta   >Gadrl                   ; 0 to Gadrl and Gadrh
0693 CEA7 8F 3F C0 E1           sta   >Gadrh                   ;
0694 CEAB A9 60                 lda   #GPtrInc+GRamSel
0695 CEAD 0F CA 00 E1           ora   >IRQ_Volume              ; get 4-bit sysvol image
0696 CEB1 8F 3C C0 E1           sta   >GStatReg                ; access RAM and increment
0697 CEB5 A9 80                 lda   #$80                     ; data value
0698 CEB7 8F 3D C0 E1  SB1      sta   >GDatReg
0699 CEBB E8                    inx   
0700 CEBC D0 F9                 bne   SB1                      ; loop 64K times
0701 CEBE                       LONGA ON                       ;
0702 CEBE                       LONGI ON                       ;
0703 CEBE C2 30                 rep   #$30                     ;
0704 CEC0 60                    rts                            ; >>>--- exit wipe.doc.ram --->>>
0705 CEC1              ;
0706 CEC1              ;
0707 CEC1                       EJECT 
0708 CEC1              ********************************************************
0709 CEC1              *
0710 CEC1              * ReadEblock: This function will read a specified number of bytes from
0711 CEC1              *              DOC ram into a user specified buffer anywhere in memory.
0712 CEC1              *              All parameters are passed on the stack.  The stack is
0713 CEC1              *              configured as follows:
0714 CEC1              *
0715 CEC1              *     Entry:
0716 CEC1              *              +----------+
0717 CEC1              *              |   $00    |
0718 CEC1              *              +----------+          e=0 ; native mode
0719 CEC1              *              |   Bank   |          m=0 ; 16 bit accumulator/memory
0720 CEC1              *              +----------+          x=0 ; 16 bit index registers
0721 CEC1              *              |Addr. high|
0722 CEC1              *              +----------+
0723 CEC1              *              | Addr low |
0724 CEC1              *              +----------+
0725 CEC1              *              |DOC addrl |
0726 CEC1              *              +----------+
0727 CEC1              *              |DOC addrh |
0728 CEC1              *              +----------+
0729 CEC1              *              |count low |
0730 CEC1              *              +----------+
0731 CEC1              *              |Count high|
0732 CEC1              *              +----------+
0733 CEC1              *              | RTL bank |
0734 CEC1              *              +----------+
0735 CEC1              *              | RTL alow |
0736 CEC1              *              +----------+
0737 CEC1              *              | RTL ahi  |
0738 CEC1              *              +----------+
0739 CEC1              *              | RTL bank |
0740 CEC1              *              +----------+
0741 CEC1              *              | RTL alow |
0742 CEC1              *              +----------+
0743 CEC1              *              | RTL ahi  |
0744 CEC1              *              +----------+
0745 CEC1              *    SP >>--->>|          |
0746 CEC1              *
0747 CEC1              *     Exit:
0748 CEC1              *         e = 0 ; native mode
0749 CEC1              *         m = 0 ; 16 bit accumulator
0750 CEC1              *         x = 0 ; 16 bit index registers
0751 CEC1              *         A = 0, carry = 0 for successful call
0752 CEC1              *         A = error code, carry = 1 for call failed
0753 CEC1              *
0754 CEC1              ********************************************************
0755 CEC1              ;
0756 CEC1              ;
0757 CEC1                       LONGA ON                       ;
0758 CEC1              ReadEblock                              ;
0759 CEC1 AF D6 00 E1           lda   >DOCFlag
0760 CEC5 29 FF 00              and   #$FF                     ; mask to low-byte
0761 CEC8 F0 09                 beq   REB1                     ; 0 indicates DOC installed
0762 CECA A2 10 00              ldx   #NoDOCErr                ;
0763 CECD A0 08 00              ldy   #8                       ; exit w/ err message
0764 CED0 4C BE CB              jmp   oerrout                  ;
0765 CED3 0B           REB1     phd                            ; save direct register
0766 CED4 A3 09                 lda   $09,s                    ; get the count
0767 CED6 AA                    tax                            ; save the count
0768 CED7 3A                    dec   A                        ; adjust for possible one byte write to $FFFF
0769 CED8 18                    clc                            ; check for range error
0770 CED9 63 0B                 adc   $0B,s                    ; add in the starting address
0771 CEDB 90 09                 bcc   rrange_ok                ; within range
0772 CEDD A2 11 00              ldx   #$0011                   ; mark a range error
0773 CEE0 A0 08 00              ldy   #8                       ; routine will pop direct register
0774 CEE3 4C BD CB              jmp   Errout                   ;
0775 CEE6              rrange_ok                               ;
0776 CEE6 A0 00 00              ldy   #$00                     ; point to system ram buffer
0777 CEE9 A3 0B                 lda   $0B,s                    ; point to 1st Ensoniq ram locatio to read
0778 CEEB 8F 3E C0 E1           sta   >gadrl                   ;
0779 CEEF 3B                    tsc                            ; make a direct page
0780 CEF0 5B                    tcd                            ;
0781 CEF1                       LONGA OFF                      ;
0782 CEF1 E2 20                 sep   #$20                     ; 8 bit accumulator
0783 CEF3 A9 60                 lda   #Gptrinc+Gramsel         ; point to Ensoniq ram with auto incr.
0784 CEF5 0F CA 00 E1           ora   >Irq_volume              ; include the system volume
0785 CEF9 8F 3C C0 E1           sta   >Gstatreg                ;
0786 CEFD AF 3D C0 E1           lda   >gdatreg                 ; dummy read
0787 CF01              readeloop                               ;
0788 CF01 AF 3D C0 E1           lda   >gdatreg                 ; get a data byte
0789 CF05 97 0D                 sta   [$0D],y                  ; put it away
0790 CF07 C8                    iny                            ; bump ram pointer
0791 CF08 CA                    dex                            ; decrement count
0792 CF09 D0 F6                 bne   readeloop                ; keep going until zero
0793 CF0B C2 20                 rep   #$20                     ; 16 bit accumulator/memory
0794 CF0D A0 08 00              ldy   #8                       ; it worked go away
0795 CF10 4C B7 CB              jmp   Endcall                  ;
0796 CF13              ;
0797 CF13              ;
0798 CF13                       EJECT 
0799 CF13              ********************************************************
0800 CF13              *
0801 CF13              * Write.Eblock: This function will write a specified number of bytes from
0802 CF13              *              system ram into DOC ram. The starting address is provided
0803 CF13              *              by the application. Parameters are passed on the stack.
0804 CF13              *              The stack is configured as follows:
0805 CF13              *
0806 CF13              *     Entry:
0807 CF13              *              +----------+
0808 CF13              *              |   $00    |
0809 CF13              *              +----------+          e=0 ; native mode
0810 CF13              *              |   Bank   |          m=0 ; 16 bit accumulator/memory
0811 CF13              *              +----------+          x=0 ; 16 bit index registers
0812 CF13              *              |Addr. high|
0813 CF13              *              +----------+
0814 CF13              *              | Addr low |
0815 CF13              *              +----------+
0816 CF13              *              |DOC addrl |
0817 CF13              *              +----------+
0818 CF13              *              |DOC addrh |
0819 CF13              *              +----------+
0820 CF13              *              |count low |
0821 CF13              *              +----------+
0822 CF13              *              |Count high|
0823 CF13              *              +----------+
0824 CF13              *              | RTL bank |
0825 CF13              *              +----------+
0826 CF13              *              | RTL alow |
0827 CF13              *              +----------+
0828 CF13              *              | RTL ahi  |
0829 CF13              *              +----------+
0830 CF13              *              | RTL bank |
0831 CF13              *              +----------+
0832 CF13              *              | RTL alow |
0833 CF13              *              +----------+
0834 CF13              *              | RTL ahi  |
0835 CF13              *              +----------+
0836 CF13              *    SP >>--->>|          |
0837 CF13              *
0838 CF13              *     Exit:
0839 CF13              *         e = 0 ; native mode
0840 CF13              *         m = 0 ; 16 bit accumulator
0841 CF13              *         x = 0 ; 16 bit index registers
0842 CF13              *         A = 0, carry = 0 for successful call
0843 CF13              *         A = error code, carry = 1 for call failed
0844 CF13              *
0845 CF13              ********************************************************
0846 CF13              ;
0847 CF13              ;
0848 CF13                       LONGA ON                       ;
0849 CF13              WriteEblock                             ;
0850 CF13 AF D6 00 E1           lda   >DOCFlag                 ; get the DOC installed flag
0851 CF17 29 FF 00              and   #$FF                     ; mask to lo-byte
0852 CF1A F0 09                 beq   WEB1                     ; DOC installed if = 0
0853 CF1C A9 10 00              lda   #NoDOCErr                ; error message
0854 CF1F A0 08 00              ldy   #8                       ; exit w/ message
0855 CF22 4C BE CB              jmp   oerrout                  ;
0856 CF25 0B           WEB1     phd                            ; save direct register
0857 CF26 A3 09                 lda   $09,s                    ; get the count
0858 CF28 AA                    tax                            ; save the count
0859 CF29 3A                    dec   A                        ; adjust for 1 byte write to $FFFF
0860 CF2A 18                    clc                            ; check for range error
0861 CF2B 63 0B                 adc   $0B,s                    ; add in the starting address
0862 CF2D 90 09                 bcc   wrange_ok                ; within range
0863 CF2F A2 11 00              ldx   #$0011                   ; mark a range error
0864 CF32 A0 08 00              ldy   #8                       ; routine will pop direct register
0865 CF35 4C BD CB              jmp   Errout                   ;
0866 CF38              wrange_ok                               ;
0867 CF38 A0 00 00              ldy   #$00                     ; point to data source
0868 CF3B A3 0B                 lda   $0B,s                    ; the addr. of 1st Ensoniq ram location to write
0869 CF3D 8F 3E C0 E1           sta   >gadrl                   ; point to end of DOC ram to read
0870 CF41 3B                    tsc                            ; make a direct page
0871 CF42 5B                    tcd                            ;
0872 CF43                       LONGA OFF                      ;
0873 CF43 E2 20                 sep   #$20                     ; 8 bit accumulator
0874 CF45 A9 60                 lda   #Gptrinc+Gramsel         ; enable ram access & auto incr.
0875 CF47 0F CA 00 E1           ora   >Irq_volume              ; include the system volume
0876 CF4B 8F 3C C0 E1           sta   >Gstatreg                ;
0877 CF4F              writeeloop                              ;
0878 CF4F B7 0D                 lda   [$0D],y                  ; get a data byte
0879 CF51 8F 3D C0 E1           sta   >gdatreg                 ; put it away
0880 CF55 C8                    iny                            ; bump source pointer
0881 CF56 CA                    dex                            ; decrement count
0882 CF57 D0 F6                 bne   writeeloop               ; keep going until zero
0883 CF59 C2 20                 rep   #$20                     ; 16 bit accumulator/memory
0884 CF5B A0 08 00              ldy   #8                       ; it worked go away
0885 CF5E 4C B7 CB              jmp   Endcall                  ;
0886 CF61              ;
0887 CF61              ;
0888 CF61                       EJECT 
0889 CF61                       LONGA ON
0890 CF61              ************************************************************
0891 CF61              *
0892 CF61              * SetVolume tool sets either a DOC oscillator Volume or
0893 CF61              * the system Volume.  DOC VolNum's are 0-31. VolNum's 31-255
0894 CF61              * all set the system volume.
0895 CF61              *
0896 CF61              * All Volume levels are 8-bits (0-255).  The current
0897 CF61              * system volume hardware only supports 16 volume levels
0898 CF61              * so only the upper 4-bits of the volume level are used.
0899 CF61              *
0900 CF61              *
0901 CF61              *    Called:  pea VolLevel
0902 CF61              *             pea VolNum
0903 CF61              *             _SetSoundVolume
0904 CF61              *
0905 CF61              *  Returns:  nothing
0906 CF61              *
0907 CF61              ************************************************************
0908 CF61              *
0909 CF61 20 A7 CF     SetVolume jsr   WhichVol                ; system vol or DOC vol?
0910 CF64                       LONGA OFF
0911 CF64 A3 09                 lda   W2,s                     ; get the volume setting
0912 CF66 B0 10                 bcs   SSVol                    ; WhichVol sets cy for sysvol
0913 CF68 8F 3D C0 E1           sta   >GDatReg                 ; write volume to 1st osc
0914 CF6C 8F 3D C0 E1           sta   >GDatReg                 ; and the 2nd osc.
0915 CF70 C2 20        Exit2M   rep   #$20                     ; reset M-bit
0916 CF72 A0 04 00              ldy   #4                       ; and exit, dropping 2 wds
0917 CF75 4C B8 CB              jmp   Oendcall
0918 CF78              *
0919 CF78 8F B0 1D E1  SSVol    sta   >Sram_base+SysVolLoc     ; save the 8-bit vol value
0920 CF7C 4A                    lsr   a
0921 CF7D 4A                    lsr   a
0922 CF7E 4A                    lsr   a
0923 CF7F 4A                    lsr   a                        ; divide by 16
0924 CF80 8F CA 00 E1           sta   >IRQ_Volume              ; save 4-bit version
0925 CF84 8F 3C C0 E1           sta   >GStatReg                ; set sys hardware volume
0926 CF88 80 E6                 bra   Exit2M                   ; reset M & exit
0927 CF8A
0928 CF8A
0929 CF8A
0930 CF8A              ************************************************************
0931 CF8A              *
0932 CF8A              * GetVolume tool acts like SetVolume except it returns the
0933 CF8A              * specified volume level.
0934 CF8A              *
0935 CF8A              *    Called: pea $0 ; return value placeholder
0936 CF8A              *            pea VolNum
0937 CF8A              *            _GetSoundVolume
0938 CF8A              *
0939 CF8A              *  Returns: specified volume level
0940 CF8A              *
0941 CF8A              ************************************************************
0942 CF8A              *
0943 CF8A 20 A7 CF     GetVolume jsr   WhichVol                ; sys vol or DOC vol
0944 CF8D                       LONGA OFF
0945 CF8D B0 0A                 bcs   GSVol                    ; sysvol if cy set
0946 CF8F AF 3D C0 E1           lda   >GDatReg                 ; a dummy read
0947 CF93 AF 3D C0 E1           lda   >GDatReg                 ; read the DOC osc vol.
0948 CF97 80 04                 bra   GSV1
0949 CF99 AF B0 1D E1  GSVol    lda   >Sram_base+sysvolloc     ; read the system volume
0950 CF9D 83 09        GSV1     sta   W2,s
0951 CF9F              *
0952 CF9F C2 20        Exit1M   rep   #$20                     ; set 16-bit AC
0953 CFA1                       LONGA ON
0954 CFA1 A0 02 00              ldy   #2                       ; exit w/o pld, drop 1 wd.
0955 CFA4 4C B8 CB              jmp   Oendcall
0956 CFA7              *
0957 CFA7              * WhichVol examines the volnum in the top stack parm
0958 CFA7              * and returns w/ cy set if > 15.  If VolNum is < 16,
0959 CFA7              * the sound glu is setup and pointed to the first osc in
0960 CFA7              * the specified logical sound generator.
0961 CFA7              *
0962 CFA7                       LONGA OFF
0963 CFA7 E2 20        WhichVol sep   #$20                     ; 8-bit m
0964 CFA9 A3 09                 lda   W2,s                     ; get VolNum
0965 CFAB C9 0F                 cmp   #15                      ; >15? set cy for SysVol.
0966 CFAD B0 19                 bcs   WVR                      ; return if SysVol
0967 CFAF EB                    xba                            ; get B-Reg
0968 CFB0 A9 00                 lda   #0                       ; and clear it
0969 CFB2 EB                    xba                            ; get back AC
0970 CFB3 AA                    tax   
0971 CFB4 BF 5E CE FC           lda   >OscTable,x              ; get phys osc number
0972 CFB8 69 40                 adc   #EVol                    ; add DOC vol reg base addr
0973 CFBA 8F 3E C0 E1           sta   >Gadrl                   ; set glu addr
0974 CFBE A9 20                 lda   #GRegSel+gptrinc         ; DOC select / auto incr
0975 CFC0 0F CA 00 E1           ora   >IRQ_Volume              ; get the 4-bit sysvol image
0976 CFC4 8F 3C C0 E1           sta   >GStatReg                ; set GLU to access DOC, not RAM
0977 CFC8 60           WVR      rts   
0978 CFC9
0979 CFC9
0980 CFC9              ********************************************************
0981 CFC9              *
0982 CFC9              * Stop.Sound: This routine will stop a Sound generator in the DOC.
0983 CFC9              *             It checks the active flag and stops only the oscillators
0984 CFC9              *             which are running.
0985 CFC9              *
0986 CFC9              *     Import: Function # = $00
0987 CFC9              *             +------------+
0988 CFC9              *             |  Mask low  |
0989 CFC9              *             +------------+
0990 CFC9              *             | Mask high  |
0991 CFC9              *             +------------+
0992 CFC9              *             |  low byte  |
0993 CFC9              *             +------------+
0994 CFC9              *             |  high byte |
0995 CFC9              *             +------------+
0996 CFC9              *             |    bank    |
0997 CFC9              *             +------------+
0998 CFC9              *             |  low byte  |
0999 CFC9              *             +------------+
1000 CFC9              *             |  high byte |
1001 CFC9              *             +------------+
1002 CFC9              *             |    bank    |
1003 CFC9              *             +------------+
1004 CFC9              * SP >>>--->>
1005 CFC9              *
1006 CFC9              ********************************************************
1007 CFC9              ;
1008 CFC9              ;
1009 CFC9              Stopsound  
1010 CFC9
1011 CFC9 0B                    phd                            ;save direct register
1012 CFCA 8B                    phb                            ; save data bank register
1013 CFCB 08                    php                            ; save m & x bits
1014 CFCC 78                    sei                            ; no interruptions
1015 CFCD 5B                    tcd                            ; set direct reg to our WAP
1016 CFCE                       longa off                      ;
1017 CFCE E2 20                 sep   #$20                     ; 8 bit accumulator
1018 CFD0 A9 E1                 lda   #sram_bank               ; point to working ram
1019 CFD2 48                    pha                            ;
1020 CFD3 AB                    plb                            ;
1021 CFD4 AD 3C C0              lda   sgctrl                   ; read the Sound glu control register
1022 CFD7 29 F0                 and   #$F0                     ; mask off low nibble
1023 CFD9 0F CA 00 E1           ora   >irq_volume              ; include the system volume
1024 CFDD 48                    pha                            ; save it
1025 CFDE 29 0F                 and   #gvol                    ; select the DOC with no auto incr
1026 CFE0 09 20                 ora   #auto_incr               ; sound glu auto incr. enabled
1027 CFE2 8D 3C C0              sta   sgctrl                   ; and leave sys volume alone
1028 CFE5                       longa on                       ;
1029 CFE5 C2 20                 rep   #$20                     ;
1030 CFE7 AF B2 1D E1           lda   >sram_base+active_oscs   ; get active oscillators
1031 CFEB 23 0C                 and   $0C,s                    ; include the mask
1032 CFED 8F B4 1D E1           sta   >sram_base+off_bits      ; save bits for oscillators to turn off
1033 CFF1 4F B2 1D E1           eor   >sram_base+active_oscs   ; turn off active bits on specified oscs_
1034 CFF5 8F B2 1D E1           sta   >sram_base+active_oscs   ;
1035 CFF9 A2 10 00              ldx   #$10                     ; 16 generators $00-$0F
1036 CFFC              osc_off_loop equ   *                    ;
1037 CFFC CA                    dex                            ; point to first oscillator
1038 CFFD                       longa on                       ;
1039 CFFD C2 20                 rep   #$20                     ; back into 16 bit accum / memory
1040 CFFF AF B4 1D E1           lda   >sram_base+off_bits      ; get oscillators to shut off
1041 D003 0A                    asl   A
1042 D004              ;
1043 D004 8F B4 1D E1           sta   >sram_base+off_bits      ;
1044 D008 B0 04                 bcs   osc_off                  ; if set then turn it off
1045 D00A F0 77                 beq   osc_off_exit             ; all done go away
1046 D00C 80 EE                 bra   osc_off_loop             ; keep going until all off
1047 D00E              osc_off  equ   *                        ;
1048 D00E                       longa off                      ;
1049 D00E E2 20                 sep   #$20                     ; 8 bit accum / memory
1050 D010 BF 5E CE FC           lda   >osctable,x              ; get the oscillator number
1051 D014 48                    pha                            ; save oscillator number
1052 D015 18                    clc                            ; point to oscillator number
1053 D016 69 00                 adc   #efreqlo                 ; point to low byte of frequency
1054 D018 8D 3E C0              sta   sgadrl                   ;
1055 D01B 9C 3D C0              stz   sgdata                   ; zero out both oscillators
1056 D01E 9C 3D C0              stz   sgdata                   ;
1057 D021 A3 01                 lda   $01,s                    ; get oscillator number
1058 D023 18                    clc                            ;
1059 D024 69 20                 adc   #efreqhi                 ; point to high byte of frequency reg
1060 D026 8D 3E C0              sta   sgadrl                   ;
1061 D029 9C 3D C0              stz   sgdata                   ; zero out both oscillators
1062 D02C 9C 3D C0              stz   sgdata                   ;
1063 D02F A3 01                 lda   $01,s                    ; get oscillator number
1064 D031 18                    clc                            ;
1065 D032 69 A0                 adc   #eocr                    ;
1066 D034              check_again equ   *
1067 D034 8D 3E C0              sta   sgadrl                   ;
1068 D037 EB                    xba                            ; save register number
1069 D038              ;        lda   sgdata                   ; get current DOC control reg
1070 D038              ;        lda   sgdata                   ;
1071 D038              ;        and   #eocrid                  ; disable interrupts
1072 D038              ;        ora   #eocrhlt                 ; halt the oscillator
1073 D038 A9 01                 lda   #$01                     ; with no irqs
1074 D03A EB                    xba                            ;
1075 D03B 8D 3E C0              sta   sgadrl                   ; point to oscillator control
1076 D03E EB                    xba                            ;
1077 D03F 8D 3D C0              sta   sgdata                   ; for both oscillators
1078 D042 8D 3D C0              sta   sgdata                   ; write out new DOC control byte
1079 D045 EB                    xba                            ; get reg number
1080 D046 8D 3E C0              sta   sgadrl                   ;
1081 D049 EB                    xba                            ; keep reg number
1082 D04A AD 3D C0              lda   sgdata                   ; discard this read
1083 D04D AD 3D C0              lda   sgdata                   ; even oscillator control byte
1084 D050 29 01                 and   #$01                     ; keep halt bit
1085 D052 2D 3D C0              and   sgdata                   ; if non zero go do next generator
1086 D055 D0 08                 bne   go_do_next               ;
1087 D057 A9 14                 lda   #$14                     ; kill 50+ usecs. minimum to let DOC complete cycle
1088 D059 3A           kill_loop dec   A                       ;
1089 D05A D0 FD                 bne   kill_loop                ;
1090 D05C EB                    xba                            ; get register number back
1091 D05D 80 D5                 bra   check_again              ;
1092 D05F              go_do_next equ   *                      ;
1093 D05F 68                    pla                            ; restore oscillator number
1094 D060 18                    clc                            ;
1095 D061 69 40                 adc   #evol                    ; point to volume registers
1096 D063 8D 3E C0              sta   sgadrl                   ;
1097 D066 9C 3D C0              stz   sgdata                   ; turn down off the volume
1098 D069 9C 3D C0              stz   sgdata                   ; for both oscillators
1099 D06C AF B6 1D E1           lda   >sram_base+wap_installed ; check for wap installed
1100 D070 F0 8A                 beq   osc_off_loop             ; and if installed then mark mode byte free
1101 D072 DA                    phx                            ; save count
1102 D073 A9 00                 lda   #$00                     ;must set 'b' part of 'c'=0
1103 D075 EB                    xba                            ;
1104 D076 BF 8E CE FC           lda   >gcb_xlate,x             ; get index into gcb for oscillator
1105 D07A AA                    tax                            ;
1106 D07B 74 00                 stz   <gcb_mode,x              ; clear first word of gcb
1107 D07D 74 01                 stz   <gcb_gen,x               ;
1108 D07F FA                    plx                            ; restore count
1109 D080 82 79 FF              brl   osc_off_loop             ;
1110 D083              osc_off_exit equ   *                    ;
1111 D083                       longa off
1112 D083 E2 20                 sep   #$20                     ; 8 bits accum / memory
1113 D085 68                    pla                            ; restore sound glu control register
1114 D086 8D 3C C0              sta   sgctrl                   ; put it back
1115 D089 28                    plp                            ; restore status register
1116 D08A AB                    plb                            ; restore data bank register
1117 D08B A0 02 00              ldy   #2
1118 D08E 4C B7 CB              jmp   Endcall
1119 D091
1120 D091              ;
1121 D091              ;
1122 D091                       TITLE 'Sound tools startup call status' 
1123 D091                       EJECT 
1124 D091              ********************************************************
1125 D091              *
1126 D091              * Sstart.stat: This routine will return the status of the sound tools
1127 D091              *              startup call.
1128 D091              *
1129 D091              *     Import: stack+1 ; room for status result
1130 D091              *             stack+2 ;
1131 D091              *
1132 D091              ********************************************************
1133 D091              ;
1134 D091              ;
1135 D091              Sstart_stat                             ;
1136 D091 E2 20                 sep   #$20                     ; 8 bit accumulator
1137 D093 AF C1 1D E1           lda   >sram_base+start_stat    ; get status for startup call
1138 D097 83 07                 sta   $7,s                     ; put result on the stack
1139 D099 83 08                 sta   $08,s                    ; one word
1140 D09B C2 20                 rep   #$20                     ; back to 16 bit accumulator
1141 D09D A0 00 00              ldy   #0
1142 D0A0 4C B8 CB              jmp   Oendcall
1143 D0A3              ;
1144 D0A3              ;
1145 D0A3                       TITLE 'Get sound status' 
1146 D0A3                       EJECT 
1147 D0A3              ********************************************************
1148 D0A3              *
1149 D0A3              * Sound.status: This routine will return a word showing which
1150 D0A3              *               oscillators are active.
1151 D0A3              *
1152 D0A3              *     Import: Function # = $00
1153 D0A3              *             +------------+
1154 D0A3              *             | status low |    Room for one word of status
1155 D0A3              *             +------------+
1156 D0A3              *             | Status high|
1157 D0A3              *             +------------+
1158 D0A3              *             |  low byte  |
1159 D0A3              *             +------------+
1160 D0A3              *             |  high byte |
1161 D0A3              *             +------------+
1162 D0A3              *             |    bank    |
1163 D0A3              *             +------------+
1164 D0A3              *             |  low byte  |
1165 D0A3              *             +------------+
1166 D0A3              *             |  high byte |
1167 D0A3              *             +------------+
1168 D0A3              *             |    bank    |
1169 D0A3              *             +------------+
1170 D0A3              * SP >>>--->>
1171 D0A3              *
1172 D0A3              *     Export:
1173 D0A3              *            (Stack+8) = high byte of DOC active oscillators
1174 D0A3              *            (Stack+7) = low byte of DOC active oacillators
1175 D0A3              *
1176 D0A3              *     Errors:
1177 D0A3              *            NONE
1178 D0A3              *
1179 D0A3              ********************************************************
1180 D0A3              ;
1181 D0A3              ;
1182 D0A3              Sound_status                            ;
1183 D0A3 AF B2 1D E1           lda   >sram_base+Active_oscs   ; get active oscillators word
1184 D0A7 83 07                 sta   $07,s                    ; put in the holding location
1185 D0A9 A0 00 00              ldy   #0                       ; no parameters to strip off
1186 D0AC 4C B8 CB              jmp   Oendcall
1187 D0AF              ;
1188 D0AF              ;
1189 D0AF                       TITLE 'Sound tools generator_status' 
1190 D0AF                       EJECT 
1191 D0AF              ********************************************************
1192 D0AF              *
1193 D0AF              * Gen.stat: This routine will return the status of a generator
1194 D0AF              *
1195 D0AF              *     Import: stack+1 ; room for status result
1196 D0AF              *             stack+2 ;
1197 D0AF              *             stack+3 ; generator number
1198 D0AF              *             stack+4 ;
1199 D0AF              *
1200 D0AF              ********************************************************
1201 D0AF              ;
1202 D0AF                       LONGA ON                       ;
1203 D0AF                       LONGI ON                       ;
1204 D0AF              ;
1205 D0AF              Gen_stat                                ;
1206 D0AF C9 00 00              cmp   #$0000                   ; check if wap installed
1207 D0B2 F0 2D                 beq   gen_stat_error           ;
1208 D0B4 0B                    phd                            ; save direct register
1209 D0B5 48                    pha                            ; set direct register
1210 D0B6 2B                    pld                            ;
1211 D0B7 A3 09                 lda   $09,s                    ; get generator number
1212 D0B9 C9 0F 00              cmp   #$000F                   ; keep generator $00-$0E
1213 D0BC 90 09                 bcc   @1                       ; bad generator number
1214 D0BE A2 13 00              ldx   #badgen                  ; invalid generator number
1215 D0C1 A0 02 00              ldy   #2                       ;
1216 D0C4 4C BD CB              jmp   Errout                   ;
1217 D0C7 AA           @1       tax                            ; form generator table index
1218 D0C8                       LONGA OFF                      ;
1219 D0C8                       LONGI OFF                      ;
1220 D0C8 E2 30                 sep   #$30                     ;
1221 D0CA A9 FF                 lda   #$FF                     ; assume gen busy
1222 D0CC EB                    xba                            ;
1223 D0CD BF 8E CE FC           lda   >gcb_xlate,x             ; get address of gcb
1224 D0D1 AA                    tax                            ;
1225 D0D2                       LONGA ON                       ;
1226 D0D2                       LONGI ON                       ;
1227 D0D2 C2 30                 rep   #$30
1228 D0D4 B5 00                 lda   gcb_mode,x               ; get the mode byte for the oscillator
1229 D0D6 EB                    xba                            ; gen # high byte, mode low byte
1230 D0D7              exit_gen_stat                           ;
1231 D0D7 C2 30                 rep   #$30
1232 D0D9 83 0B                 sta   $0B,s                    ;
1233 D0DB A0 02 00              ldy   #2                       ;
1234 D0DE 4C B7 CB              jmp   Endcall                  ;
1235 D0E1              ;
1236 D0E1              ;
1237 D0E1              gen_stat_error                          ;
1238 D0E1                       LONGA ON                       ;
1239 D0E1                       LONGI ON                       ;
1240 D0E1 A2 12 00              ldx   #wap_error               ; mark an error
1241 D0E4 A0 02 00              ldy   #2                       ;
1242 D0E7 4C BE CB              jmp   oerrout                  ;
1243 D0EA              ;
1244 D0EA              ;
1245 D0EA                       TITLE 'Set Master interrupt vector' 
1246 D0EA                       EJECT 
1247 D0EA              ********************************************************
1248 D0EA              *
1249 D0EA              * Smirq: This routine will set the master interrupt vector to a user
1250 D0EA              *        specified vector.  If this vector is changed it is the
1251 D0EA              *        responsibility of the user to service the interrupts generated
1252 D0EA              *        by the DOC.
1253 D0EA              *
1254 D0EA              *     Entry:
1255 D0EA              *              +----------+
1256 D0EA              *              |   $00    |
1257 D0EA              *              +----------+          e=0 ; native mode
1258 D0EA              *              |   Bank   |          m=0 ; 16 bit accumulator/memory
1259 D0EA              *              +----------+          x=0 ; 16 bit index registers
1260 D0EA              *              |Addr. high|
1261 D0EA              *              +----------+     New master interrupt address
1262 D0EA              *              |Addr. low |
1263 D0EA              *              +----------+
1264 D0EA              *              | RTL bank |
1265 D0EA              *              +----------+
1266 D0EA              *              | RTL alow |
1267 D0EA              *              +----------+
1268 D0EA              *              | RTL ahi  |
1269 D0EA              *              +----------+
1270 D0EA              *              | RTL bank |
1271 D0EA              *              +----------+
1272 D0EA              *              | RTL alow |
1273 D0EA              *              +----------+
1274 D0EA              *              | RTL ahi  |
1275 D0EA              *              +----------+
1276 D0EA              *    SP >>--->>|          |
1277 D0EA              *
1278 D0EA              *     Exit:
1279 D0EA              *         e = 0 ; native mode
1280 D0EA              *         m = 0 ; 16 bit accumulator
1281 D0EA              *         x = 0 ; 16 bit index registers
1282 D0EA              *         A = 0, carry = 0 for successful call
1283 D0EA              *
1284 D0EA              ********************************************************
1285 D0EA              ;
1286 D0EA              ;
1287 D0EA                       LONGA ON
1288 D0EA                       LONGI ON
1289 D0EA              Smirq                                   ;
1290 D0EA AF B6 1D E1           lda   >sram_base+wap_installed ; get the wap installed flag
1291 D0EE 29 FF 00              and   #$00FF                   ; low byte
1292 D0F1 D0 09                 bne   set_mvect                ; install user vector
1293 D0F3 A2 12 00              ldx   #wap_error               ; no work area
1294 D0F6 A0 04 00              ldy   #4                       ;
1295 D0F9 4C BE CB              jmp   oerrout                  ;
1296 D0FC              set_mvect                               ;
1297 D0FC F4 0B 00              pea   sound_vect_ref           ; sound irq vector ref number
1298 D0FF A3 0B                 lda   $0B,s                    ; get the vector address
1299 D101 48                    pha                            ;
1300 D102 A3 0B                 lda   $0B,s                    ; offset by two bytes
1301 D104 48                    pha                            ;
1302 D105 A2 03 10 22           _SetVector 
1303 D10C                       LONGA OFF                      ;
1304 D10C E2 20                 sep   #$20                     ;
1305 D10E A9 FF                 lda   #$FF                     ; mark master irq vector installed
1306 D110 8F B9 1D E1           sta   >sram_base+mirq_defined  ;
1307 D114                       LONGA ON
1308 D114 C2 20                 rep   #$20                     ;
1309 D116 A0 04 00              ldy   #4                       ; strip 4 bytes off the stack
1310 D119 4C B8 CB              jmp   Oendcall
1311 D11C              ;
1312 D11C              ;
1313 D11C                       TITLE 'Set Users interrupt vector' 
1314 D11C                       EJECT 
1315 D11C              ********************************************************
1316 D11C              *
1317 D11C              * Suirq: This routine will set the users interrupt vector to a value
1318 D11C              *        defined by the caller.  If the synthesizer is not one defined
1319 D11C              *        for the firmware control will be passed to the users synth.
1320 D11C              *        code.  On powerup the users interrupt vector will be pointed
1321 D11C              *        a invalid synthesizer error routine.
1322 D11C              *
1323 D11C              *     Entry:
1324 D11C              *              +----------+
1325 D11C              *              |   $00    |
1326 D11C              *              +----------+          e=0 ; native mode
1327 D11C              *              |   Bank   |          m=0 ; 16 bit accumulator/memory
1328 D11C              *              +----------+          x=0 ; 16 bit index registers
1329 D11C              *              |Addr. high|
1330 D11C              *              +----------+     New users interrupt address
1331 D11C              *              |Addr. low |
1332 D11C              *              +----------+
1333 D11C              *              | RTL bank |
1334 D11C              *              +----------+
1335 D11C              *              | RTL alow |
1336 D11C              *              +----------+
1337 D11C              *              | RTL ahi  |
1338 D11C              *              +----------+
1339 D11C              *              | RTL bank |
1340 D11C              *              +----------+
1341 D11C              *              | RTL alow |
1342 D11C              *              +----------+
1343 D11C              *              | RTL ahi  |
1344 D11C              *              +----------+
1345 D11C              *    SP >>--->>|          |
1346 D11C              *
1347 D11C              *     Exit:
1348 D11C              *         e = 0 ; native mode
1349 D11C              *         m = 0 ; 16 bit accumulator
1350 D11C              *         x = 0 ; 16 bit index registers
1351 D11C              *         A = 0, carry = 0 for successful call
1352 D11C              *
1353 D11C              ********************************************************
1354 D11C              ;
1355 D11C              ;
1356 D11C              Suirq                                   ;
1357 D11C AF B6 1D E1           lda   >sram_base+wap_installed ; check if wap installed
1358 D120 29 FF 00              and   #$00FF                   ;
1359 D123 D0 09                 bne   set_uvect                ; installed set user vector
1360 D125 A2 12 00              ldx   #wap_error               ; not installed report error
1361 D128 A0 04 00              ldy   #4                       ;
1362 D12B 4C BE CB              jmp   oerrout                  ;
1363 D12E              set_uvect                               ;
1364 D12E AF BE 1D E1           lda   >sram_base+user_irq_vect ; hand back old vector to caller
1365 D132 83 0B                 sta   $0B,s                    ;
1366 D134 AF C0 1D E1           lda   >sram_base+user_irq_vect+2 ;
1367 D138 29 FF 00              and   #$00FF                   ; low byte only
1368 D13B 83 0D                 sta   $0D,s                    ;
1369 D13D A3 07                 lda   $07,s                    ; get the low word of the address
1370 D13F 8F BE 1D E1           sta   >sram_base+user_irq_vect ; save it
1371 D143 A3 08                 lda   $08,s                    ; get upper word of users vector
1372 D145 8F BF 1D E1           sta   >sram_base+user_irq_vect+1 ;
1373 D149 08                    php                            ; save status
1374 D14A                       LONGA OFF                      ;
1375 D14A E2 20                 sep   #$20                     ;
1376 D14C A9 5C                 lda   #$5C                     ; we get to him through a JMP long
1377 D14E 8F BD 1D E1           sta   >sram_base+user_irq      ;
1378 D152 28                    plp                            ; restore status
1379 D153 A0 04 00              ldy   #4
1380 D156 4C B8 CB              jmp   Oendcall
1381 D159              ;
1382 D159              ;
1383 D159                       EJECT 
1384 D159
1385 D159
1386 D159                       longa on
1387 D159                       longi on
1388 D159
1389 D159              SetUpSound  
1390 D159
1391 D159 0B                    phd                            ; save direct regester.
1392 D15A 08                    php                            ; save status reg
1393 D15B 5B                    tcd                            ; get my dp.
1394 D15C D0 06                 bne   @1                       ; if not zero we were started up.
1395 D15E
1396 D15E A9 12 00              lda   #NotInitted              ; Sound Tools wasn't started up.
1397 D161 4C F2 D1              jmp   error_out                ; quit returning error.
1398 D164
1399 D164 78           @1       sei                            ; no interruptions please
1400 D165 64 FA                 stz   SndFlags                 ; Don't start the generator.
1401 D167 80 10                 bra   DoStartSound             ; Continue as if startsound call.
1402 D169
1403 D169 0B           Startsound phd                          ; save direct register
1404 D16A 08                    php                            ; save status reg
1405 D16B 5B                    tcd                            ; get my dp.
1406 D16C D0 05                 bne   @1                       ; if not zero we were started up.
1407 D16E
1408 D16E A9 12 00              lda   #NotInitted              ; Sound Tools wasn't started up.
1409 D171 80 7F                 bra   error_out                ; quit returning error.
1410 D173
1411 D173 78           @1       sei                            ; no interruptions please
1412 D174 A9 00 40              lda   #StartGenFlg             ; Set flag to standard FFStartSound call.
1413 D177 85 FA                 sta   SndFlags
1414 D179
1415 D179
1416 D179              DoStartSound                            ; Entry for FFSetUpCall.
1417 D179 20 3F D3              jsr   set_gcb                  ; set up gcb
1418 D17C B0 74                 bcs   error_out                ; go away with an error
1419 D17E
1420 D17E DA                    phx                            ; save the gcb pointer
1421 D17F 20 0E D4              jsr   setup_doc_ram            ; move from system ram to DOC ram
1422 D182 FA                    plx                            ; restore gcb pointer
1423 D183
1424 D183                       LONGA OFF
1425 D183                       LONGI OFF
1426 D183
1427 D183 E2 30                 sep   #$30
1428 D185 DA                    phx                            ; save gcb.index ;
1429 D186 B5 01                 lda   gcb_gen,x                ; get the generator number
1430 D188 29 0F                 and   #$0F
1431 D18A AA                    tax   
1432 D18B BF 5E CE FC           lda   >osctable,x              ; get oscillator number
1433 D18F 18                    clc                            ; point to control registers
1434 D190 69 A0                 adc   #eocr
1435 D192 8F 3E C0 E1           sta   gadrl
1436 D196
1437 D196 AF CA 00 E1           lda   >irq_volume              ; point to DOC with no auto incr.
1438 D19A 8F 3C C0 E1           sta   gstatreg                 ;
1439 D19E FA                    plx   
1440 D19F B5 01                 lda   gcb_gen,x                ; get generator number
1441 D1A1 29 F0                 and   #$F0                     ; keep channel number
1442 D1A3 09 0E                 ora   #$0E                     ; SWAP, Irq enable, GO (halt OFF)
1443 D1A5 24 FB                 bit   SndFlags+1               ; check if OneOscFlg is set.
1444 D1A7 10 02                 bpl   @1                       ; both oscillators ($80 = 0ne osc only)
1445 D1A9
1446 D1A9 29 FA                 and   #$FA                     ; One-Shot
1447 D1AB
1448 D1AB 24 FB        @1       bit   SndFlags+1               ; check to see if we really want to start the gen.
1449 D1AD 70 1C                 bvs   New2                     ; if StartGenFlg set then start it now.
1450 D1AF
1451 D1AF
1452 D1AF              ;from here to New2 is code to halt the gen for setupparm call.
1453 D1AF              ; it is necessary to switch mode to loop and halt for both osc.
1454 D1AF
1455 D1AF DA                    phx                            ; save gcb index.
1456 D1B0 29 F1                 and   #$F1                     ; force into loop mode no irq.
1457 D1B2 09 01                 ora   #01                      ; otherwize make sure the bit is halted.
1458 D1B4 AA                    tax                            ; save for now. X has Ctrl Reg for EVEN
1459 D1B5
1460 D1B5 AF 3E C0 E1           lda   gadrl                    ; get the address.
1461 D1B9 A8                    tay                            ; save address for now.
1462 D1BA
1463 D1BA 1A                    inc   a                        ; point to odd osc.
1464 D1BB 8F 3E C0 E1           sta   gadrl                    ; because it needs to be switched out of loop mode.
1465 D1BF
1466 D1BF 8A                    txa                            ; get my control value back
1467 D1C0 8F 3D C0 E1           sta   gdatreg                  ; halt loop mode odd osc.
1468 D1C4
1469 D1C4
1470 D1C4 98                    tya                            ; get value for control reg for even osc.
1471 D1C5 8F 3E C0 E1           sta   gadrl                    ; and point to it.
1472 D1C9 8A                    txa                            ; get my control value back again.
1473 D1CA FA                    plx                            ; restore x.
1474 D1CB
1475 D1CB 8F 3D C0 E1  New2     sta   gdatreg                  ; write to DOC control reg.
1476 D1CF
1477 D1CF                       LONGA ON
1478 D1CF                       LONGI ON
1479 D1CF C2 30                 rep   #$30
1480 D1D1
1481 D1D1 B5 01                 lda   gcb_gen,x                ; get the generator number
1482 D1D3 29 0F 00              and   #$0F
1483 D1D6 A8                    tay   
1484 D1D7 A9 00 00              lda   #$00
1485 D1DA 38                    sec   
1486 D1DB 2A           shift_bits rol   A                      ; shift the active bit into position
1487 D1DC 18                    clc   
1488 D1DD 88                    dey   
1489 D1DE 10 FB                 bpl   shift_bits
1490 D1E0
1491 D1E0 0F B2 1D E1           ora   >sram_base+active_oscs   ; mark generator active
1492 D1E4 8F B2 1D E1           sta   >sram_base+active_oscs
1493 D1E8 A2 00 00              ldx   #00
1494 D1EB 28           exit_start plp                          ; restore status register
1495 D1EC A0 06 00              ldy   #6
1496 D1EF 4C B7 CB              jmp   Endcall
1497 D1F2              ;
1498 D1F2              error_out  
1499 D1F2 AA                    tax                            ; get the error code
1500 D1F3 28                    plp                            ; restore status  register
1501 D1F4 A0 06 00              ldy   #6
1502 D1F7 4C BD CB              jmp   errout
1503 D1FA              ;
1504 D1FA              ; >>>--- exit start sound --->>>
1505 D1FA              ;
1506 D1FA              ;
1507 D1FA
1508 D1FA
1509 D1FA              ********************************************************
1510 D1FA              *
1511 D1FA              * 08 Aug 90  Braz
1512 D1FA              *
1513 D1FA              * Removed odd oscillator code to prevent trashing 
1514 D1FA              * one shot mode set up by FFSetUpSound.
1515 D1FA              *
1516 D1FA              * FFSetUpSound now always leaves odd osc in swap halted.
1517 D1FA              *
1518 D1FA              ********************************************************
1519 D1FA
1520 D1FA
1521 D1FA
1522 D1FA
1523 D1FA
1524 D1FA
1525 D1FA
1526 D1FA
1527 D1FA              ********************************************************
1528 D1FA              *
1529 D1FA              * StartPlaying
1530 D1FA              *
1531 D1FA              * This call Takes a word and for each bit set clears the halt bit for the
1532 D1FA              * Corresponding generator.
1533 D1FA              *
1534 D1FA              * Note: If the generator numbering ever changes this call will have to change.
1535 D1FA              *
1536 D1FA              ********************************************************
1537 D1FA
1538 D1FA              StartPlaying  
1539 D1FA
1540 D1FA                       longa on
1541 D1FA                       longi on
1542 D1FA
1543 D1FA 0B                    phd                            ; save callers dp.
1544 D1FB 5B                    tcd                            ; get my dp.
1545 D1FC F0 61                 beq   nostart                  ; no start err.
1546 D1FE
1547 D1FE 08                    php                            ; save state.
1548 D1FF 78                    sei                            ; disable interupts.
1549 D200 A2 10 00              ldx   #16                      ; gen number.
1550 D203 A3 0A                 lda   w1+3,s                   ; get the paramater.
1551 D205
1552 D205              nextgen   
1553 D205 CA                    dex                            ; dec x to mark new generator.
1554 D206 0A                    asl   a                        ; set the carry flag, if osc x to be started.
1555 D207 90 FC                 bcc   nextgen                  ; if clear check nextgen.
1556 D209
1557 D209 48                    pha   
1558 D20A E2 20                 shortm                         ; set a to 8 bits.
1559 D20C BF 5E CE FC           lda   >osctable,x              ; get the actual osc to start.
1560 D210 18                    clc   
1561 D211 69 A0                 adc   #eocr                    ; add address to Ensonic Osc Control Reg.
1562 D213 8F 3E C0 E1           sta   gadrl                    ; point to the control byte for my gen.
1563 D217
1564 D217 AF CA 00 E1           lda   >irq_volume              ; get vol, no inc, to doc.
1565 D21B 8F 3C C0 E1           sta   gstatreg                 ; set to my mode. no inc, to doc.
1566 D21F AF 3D C0 E1           lda   gdatreg                  ; false read.
1567 D223 AF 3D C0 E1           lda   gdatreg                  ; get the contol value.
1568 D227 A8                    tay                            ; save for now
1569 D228 29 0E                 and   #$0E                     ; get ie, M1, M0 bits.
1570 D22A D0 1D                 bne   @1                       ; if any are set then it just needs to be started.
1571 D22C
1572 D22C 98                    tya                            ; else it is realy supposed to be in swap mode.
1573 D22D 09 0E                 ora   #$0E                     ; put in swap mode with IRQ,
1574 D22F A8                    tay                            ; save control reg.
1575 D230
1576 D230 AF 3E C0 E1           lda   gadrl                    ; odd osc is still in loop mode.
1577 D234 48                    pha                            ; save for now.
1578 D235 1A                    inc   a                        ; so point to it.
1579 D236 8F 3E C0 E1           sta   gadrl
1580 D23A 98                    tya                            ; get control reg back (swap halted).
1581 D23B 8F 3D C0 E1           sta   gdatreg                  ; halt in swap mode odd osc.
1582 D23F
1583 D23F 68                    pla                            ; get gadrl back for even osc.
1584 D240 8F 3E C0 E1           sta   gadrl                    ; point to even osc.
1585 D244 98                    tya                            ; get control reg back (swap halted).
1586 D245 29 FE                 and   #$FE                     ; start it.
1587 D247 80 03                 bra   @2                       ; continue checking
1588 D249 98           @1       tya                            ; get my control value back.
1589 D24A 29 FE                 and   #$FE                     ; clear the low bit (halt bit).
1590 D24C 8F 3D C0 E1  @2       sta   gdatreg                  ; start the generator.
1591 D250 C2 20                 longm                          ; set a to 16 bits.
1592 D252 68                    pla                            ; get the paramater back.
1593 D253 D0 B0                 bne   nextgen                  ; if bits set we aren't done.
1594 D255
1595 D255 A2 00 00     exit     ldx   #0                       ; no error.
1596 D258 28                    plp                            ; restore interupts.
1597 D259 A0 02 00              ldy   #2
1598 D25C 4C B7 CB              jmp   Endcall
1599 D25F
1600 D25F A2 12 00     nostart  ldx   #NotInitted              ; sound tools weren't started.
1601 D262 A0 02 00              ldy   #2
1602 D265 4C BD CB              jmp   Errout
1603 D268
1604 D268              ;
1605 D268              ; >>>--- exit Start Playing --->>>
1606 D268              ;
1607 D268              ;
1608 D268
1609 D268
1610 D268              ********************************************************
1611 D268              *
1612 D268              * SetUpParam _SetDocRegs, _ReadDocRegs.
1613 D268              *
1614 D268              * This call taks a pointer to a param block, and sets
1615 D268              * the DOC Regesters from it or reads DOC values into it.
1616 D268              * It sets some of the GCB directly a header. On Read it reads both
1617 D268              * the gen nibble and the mode. On write it only sets the mode.
1618 D268              * The high bit of the word paramater specifies whether we set
1619 D268              * the first and second highest specifies for second osc.
1620 D268              *
1621 D268              ********************************************************
1622 D268
1623 D268              SetupDoc  
1624 D268                       longa on
1625 D268                       longi on
1626 D268 0B           ReadParam phd                           ; save callers dp.
1627 D269 5B                    tcd                            ; get my dp.
1628 D26A D0 03                 bne   @1
1629 D26C 82 76 00              brl   nostarterr               ; no start err.
1630 D26F 64 FA        @1       stz   SndFlags                 ; mark as read.
1631 D271 80 09                 bra   DoIt
1632 D273
1633 D273 0B           SetUpParam phd                          ; save callers dp.
1634 D274 5B                    tcd                            ; get my dp.
1635 D275 F0 6E                 beq   nostarterr               ; no start err.
1636 D277 A9 00 80              lda   #$8000
1637 D27A 85 FA                 sta   SndFlags                 ; mark as write
1638 D27C
1639 D27C 08           DoIt     php                            ; save state.
1640 D27D 78                    sei                            ; disable interupts.
1641 D27E A5 F3                 lda   tmp_pram_ptr             ; Save this DP value just in case.
1642 D280 48                    pha   
1643 D281 A5 F5                 lda   tmp_pram_ptr+2
1644 D283 48                    pha   
1645 D284              ; Make tmp_pram_ptr point to paramater block passed in call.
1646 D284 A3 0E                 lda   W1+3+4,s                 ; get the low word of ptr.
1647 D286 85 F3                 sta   tmp_pram_ptr             ; save on dp.
1648 D288 A3 0F                 lda   W1+1+3+4,s               ; get bytes 2,3 of ptr.
1649 D28A 85 F4                 sta   tmp_pram_ptr+1           ; save in my temp ptr.
1650 D28C
1651 D28C              ; Set first two byte of GCB. These are the only bytes we set.
1652 D28C A7 F3                 lda   [tmp_pram_ptr]           ; get the word paramater.
1653 D28E 29 00 0F              and   #$0F00                   ; get just the generator.
1654 D291 EB                    xba                            ; get gen in low byte.
1655 D292 48                    pha                            ; save gen for now.
1656 D293 0A                    asl   a                        ; make into index for correct gcb.
1657 D294 0A                    asl   a                        ; multiply by 16.
1658 D295 0A                    asl   a                        ;
1659 D296 0A                    asl   a                        ;
1660 D297 AA                    tax                            ; make into index.
1661 D298
1662 D298 24 FA                 bit   SndFlags
1663 D29A 30 09                 bmi   SetMode                  ; if high bit set set mode, else read it.
1664 D29C B5 00                 lda   gcb_mode,x               ; get the mode.
1665 D29E 29 0F 00              and   #$F                      ; and only the mode.
1666 D2A1 07 F3                 ora   [tmp_pram_ptr]           ; and put it in the word paramater.
1667 D2A3 80 07                 bra   cnt1                     ; continue.
1668 D2A5 A7 F3        SetMode  lda   [tmp_pram_ptr]           ; get the word paramater.
1669 D2A7 29 0F 0F              and   #$0F0F                   ; get just mode and gen number.
1670 D2AA 95 00                 sta   gcb_mode,x               ; save the infor in gcb_mode and gcb_gen.
1671 D2AC
1672 D2AC
1673 D2AC FA           Cnt1     plx                            ; get gen num back.
1674 D2AD
1675 D2AD              ; Get Osc in x for index to DOC registers.
1676 D2AD BF 5E CE FC           lda   >OscTable,x              ; x has generator in it, get osc.
1677 D2B1 29 FF 00              and   #$00FF                   ; OscTable is a byte sized table.
1678 D2B4 AA                    tax                            ; put osc index in to x.
1679 D2B5
1680 D2B5              ; See if we set Registers for first osc.
1681 D2B5 A7 F3                 lda   [tmp_pram_ptr]           ; if high bit set do first osc.
1682 D2B7 48                    pha   
1683 D2B8 10 04                 bpl   @1                       ; if plus, check to see if we do second osc.
1684 D2BA 22 EE D2 FC           jsl   TransferData             ; set up the doc regester for first osc.
1685 D2BE E8           @1       inx                            ; move to second osc.
1686 D2BF 68                    pla                            ; if 2nd highest bit set do second osc.
1687 D2C0 29 00 40              and   #$4000                   ; get just 2nd highest bit.
1688 D2C3 F0 13                 beq   done                     ; if cleared, don't do second osc and quit.
1689 D2C5 A5 F3                 lda   tmp_pram_ptr             ; get low byte of pointer.
1690 D2C7 18                    clc                            ;
1691 D2C8 69 06 00              adc   #6                       ; point to Second Regester list.
1692 D2CB 85 F3                 sta   tmp_pram_ptr             ; save it.
1693 D2CD A5 F5                 lda   tmp_pram_ptr+2           ; just in case we wraped add carry
1694 D2CF 69 00 00              adc   #0                       ; to the high byte.
1695 D2D2 85 F5                 sta   tmp_pram_ptr+2           ; save it.
1696 D2D4 22 EE D2 FC           jsl   TransferData             ; set up the doc regester for second osc.
1697 D2D8 68           done     pla                            ; Restore DP value.
1698 D2D9 85 F5                 sta   tmp_pram_ptr+2
1699 D2DB 68                    pla   
1700 D2DC 85 F3                 sta   tmp_pram_ptr
1701 D2DE
1702 D2DE 28                    plp                            ; restore interupts.
1703 D2DF A0 04 00              ldy   #4
1704 D2E2 4C B7 CB              jmp   Endcall
1705 D2E5
1706 D2E5 A2 12 00     nostarterr ldx   #NotInitted            ; sound tools weren't started.
1707 D2E8 A0 04 00              ldy   #4
1708 D2EB 4C BD CB              jmp   Errout
1709 D2EE
1710 D2EE              ;
1711 D2EE              ; >>>--- exit Set Up Param --->>>
1712 D2EE              ;
1713 D2EE
1714 D2EE              ;
1715 D2EE              ; >>>--- start of routines used by SetUpParam --->>>
1716 D2EE              ;
1717 D2EE
1718 D2EE              * x has osc number. tmp_pram_ptr points to start of data to write.
1719 D2EE 08           TransferData php   
1720 D2EF 78                    sei                            ; no interupts while adressing DOC.
1721 D2F0
1722 D2F0 DA                    phx   
1723 D2F1 22 B2 01 E1           jsl   MIDIInputPoll            ; Poll MIDI.
1724 D2F5 FA                    plx   
1725 D2F6
1726 D2F6 E2 20                 Shortm                         ; Short Accumulator for Doc.
1727 D2F8 AF CA 00 E1           lda   >Irq_volume              ; Get vol.
1728 D2FC 8F 3C C0 E1           sta   gstatreg                 ; Set Sound Glu mode to Doc, no incr.
1729 D300
1730 D300 8A                    txa                            ; Get the Oscilator Index.
1731 D301 8F 3E C0 E1           sta   gadrl                    ; Point glu to FreqLow of Oscillator.
1732 D305 A0 02 00              ldy   #2                       ; Index into Paramaters.
1733 D308
1734 D308 24 FB        loop     bit   SndFlags+1               ; Check high bit of flags.
1735 D30A 10 06                 bpl   @1                       ; If Set Read the value.
1736 D30C B7 F3                 lda   [tmp_pram_ptr],y         ; Get Value to set.
1737 D30E 8F 3D C0 E1           sta   gdatreg                  ; Write new value.
1738 D312
1739 D312 AF 3D C0 E1  @1       lda   gdatreg                  ; False read.
1740 D316 AF 3D C0 E1           lda   gdatreg                  ; Read value.
1741 D31A 97 F3                 sta   [tmp_pram_ptr],y         ; Save the value.
1742 D31C
1743 D31C C8                    iny                            ; Get ready to save next param.
1744 D31D C0 08 00              cpy   #8                       ; Is Y = 8 ?
1745 D320 F0 1B                 beq   @exit                    ; If Yes exit, if no keep going.
1746 D322
1747 D322 AF 3E C0 E1           lda   gadrl                    ; Get current address.
1748 D326 C0 05 00              cpy   #5
1749 D329 F0 09                 beq   @2
1750 D32B 18                    clc                            ;
1751 D32C 69 20                 adc   #$20                     ; Point to next regester.
1752 D32E 8F 3E C0 E1           sta   gadrl                    ; Save it.
1753 D332 80 D4                 bra   loop                     ; do next.
1754 D334
1755 D334 18           @2       clc   
1756 D335 69 40                 adc   #$40                     ; Skip sample and go to Table.
1757 D337 8F 3E C0 E1           sta   gadrl                    ; Save it.
1758 D33B 80 CB                 bra   loop                     ; do next.
1759 D33D
1760 D33D 28           @exit    plp                            ;
1761 D33E 6B                    rtl   
1762 D33F
1763 D33F
1764 D33F              ;
1765 D33F              ; >>>--- end of routines used by Set Up Param  --->>>
1766 D33F              ;
1767 D33F              ;
1768 D33F
1769 D33F
1770 D33F                       TITLE 'Set up generator control block' 
1771 D33F                       EJECT 
1772 D33F              ********************************************************
1773 D33F              *
1774 D33F              * Set.gcb: This routine will set up the gcb parameter block for a 
1775 D33F              *          generator.
1776 D33F              *
1777 D33F              *     Import: sp + D = gen #
1778 D33F              *             sp + C = mode
1779 D33F              *             sp + B = parameter block bank
1780 D33F              *             sp + A = parameter block addrh
1781 D33F              *             sp + 9 = parameter block addrl
1782 D33F              *             sp + 8 = rts address
1783 D33F              *             sp + 6 = rtl address
1784 D33F              *             sp + 3 = rtl address
1785 D33F              *
1786 D33F              ********************************************************
1787 D33F
1788 D33F
1789 D33F              set_gcb   
1790 D33F                       LONGA OFF
1791 D33F                       LONGI OFF
1792 D33F E2 30                 sep   #$30                     ; 8 accum / index regs
1793 D341 A3 11                 lda   gen_no_loc+11,s          ; get the generator number
1794 D343 29 0F                 and   #$0F                     ; 16 generators max
1795 D345 C9 0F                 cmp   #$000F                   ; gen 15 reserved for system use
1796 D347 90 03                 bcc   gen_ok                   ; generators 0-E only!
1797 D349 82 96 00              brl   gen_err                  ; invalid generator number
1798 D34C AA           gen_ok   tax                            ;
1799 D34D BF 8E CE FC           lda   >gcb_xlate,x             ; get the gcb entry address
1800 D351 AA                    tax                            ; index into gcb table
1801 D352 AF B6 1D E1           lda   >sram_base+wap_installed ; check for a valid work area
1802 D356 D0 03                 bne   label_01                 ; no work area assigned?
1803 D358 82 79 00              brl   wap_install_err          ;
1804 D35B AF B8 1D E1  label_01 lda   >sram_base+wap_addr+1    ; get the work area pointer
1805 D35F 48                    pha                            ;
1806 D360 AF B7 1D E1           lda   >sram_base+wap_addr      ;
1807 D364 48                    pha                            ;
1808 D365 2B                    pld                            ; set new direct register
1809 D366 B5 00                 lda   gcb_tbl,x                ; get mode byte for generator
1810 D368 29 0F                 and   #$0F                     ; check the synth mode
1811 D36A F0 03                 beq   gen_not_busy             ; generator free
1812 D36C 82 6C 00              brl   gen_busy_err             ;
1813 D36F 0F B9 1D E1  gen_not_busy ora   >sram_base+mirq_defined ; check for master irq defined
1814 D373 D0 03                 bne   label_00                 ; everybody happy
1815 D375 82 78 00              brl   irq_vect_err             ; otherwise interrupt vector error
1816 D378                       LONGA ON
1817 D378 C2 20        label_00 rep   #$20                     ;
1818 D37A A3 0C                 lda   pptr_addl_loc+11,s       ; parameter table address 
1819 D37C 85 F3                 sta   tmp_pram_ptr             ;
1820 D37E A3 0D                 lda   pptr_addh_loc+11,s       ;
1821 D380 85 F4                 sta   tmp_pram_ptr+1           ;
1822 D382 A0 0C                 ldy   #next_wave_ptr           ; get the parameter block for possible next waveform
1823 D384 B7 F3                 lda   [tmp_pram_ptr],y         ;
1824 D386 95 07                 sta   gcbp_ptr,x               ; set new pointer
1825 D388 C8                    iny                            ;
1826 D389 B7 F3                 lda   [tmp_pram_ptr],y         ;
1827 D38B 95 08                 sta   gcbp_ptr+1,x             ;
1828 D38D C8                    iny                            ; point to the volume
1829 D38E C8                    iny                            ;
1830 D38F C8                    iny                            ;
1831 D390 E2 20                 sep   #$20                     ;
1832 D392 B7 F3                 lda   [tmp_pram_ptr],y         ; get the DOC volume setting
1833 D394 95 0E                 sta   gcb_doc_volume,x         ;
1834 D396 C2 20                 rep   #$20                     ;
1835 D398              buff_size_ok                            ;
1836 D398 A3 10                 lda   mode_loc+11,s            ; get the mode byte
1837 D39A 29 FF 00              and   #$00FF                   ; low nibble
1838 D39D C9 01 00              cmp   #ffsynth_mode            ; is it free form synthesizer?
1839 D3A0 D0 47                 bne   mode_err                 ; an error if not
1840 D3A2 A3 10                 lda   mode_loc+11,s            ; get the mode & gen #
1841 D3A4 95 00                 sta   gcb_mode,x               ; save it
1842 D3A6 A0 00                 ldy   #wave_start              ; point to the beginning of param block
1843 D3A8 B7 F3                 lda   [tmp_pram_ptr],y         ;
1844 D3AA 95 02                 sta   gcb_wave_pos,x           ;
1845 D3AC C8                    iny                            ; bump to bank
1846 D3AD B7 F3                 lda   [tmp_pram_ptr],y         ;
1847 D3AF 95 03                 sta   gcb_wave_pos+1,x         ;
1848 D3B1 C8                    iny                            ;
1849 D3B2 C8                    iny                            ;
1850 D3B3 C8                    iny                            ;
1851 D3B4 B7 F3                 lda   [tmp_pram_ptr],y         ; get the byte count
1852 D3B6 95 05                 sta   gcb_wave_count,x         ;
1853 D3B8 A0 08                 ldy   #doc_buff_start          ; get the start of the DOC buffer
1854 D3BA B7 F3                 lda   [tmp_pram_ptr],y         ;
1855 D3BC 95 0A                 sta   gcb_o0_start,x           ; save it
1856 D3BE                       LONGA OFF
1857 D3BE                       LONGI OFF
1858 D3BE E2 30                 sep   #$30                     ;
1859 D3C0 A0 0A                 ldy   #doc_buff_size           ; get the size of the doc buffer
1860 D3C2 B7 F3                 lda   [tmp_pram_ptr],y         ; get the doc buffer code
1861 D3C4                       LONGA ON
1862 D3C4                       LONGI ON
1863 D3C4 C2 30                 rep   #$30
1864 D3C6 29 07 00              and   #$07                     ; three bits
1865 D3C9 DA                    phx                            ; save gcb.index
1866 D3CA 0A                    asl   A                        ; times 2 for table alignment
1867 D3CB AA                    tax                            ; form table index
1868 D3CC BF FE D3 FC           lda   >buff_siz_tbl,x          ;
1869 D3D0 FA                    plx                            ; restore gcb.index
1870 D3D1 95 0C                 sta   gcb_doc_count,x          ; save the DOC buffer size
1871 D3D3 60                    rts                            ; >>>--- exit set.gcb --->>>
1872 D3D4              ;
1873 D3D4              ;
1874 D3D4                       LONGA ON
1875 D3D4                       LONGI ON                       ; changed index registers to long for errors - Braz 8-24-90
1876 D3D4
1877 D3D4              wap_install_err                         ; wap not installed error
1878 D3D4 C2 20                 rep   #$20
1879 D3D6 A9 12 00              lda   #wap_error               ; mark wap not installed error
1880 D3D9 38                    sec                            ; mark an error
1881 D3DA 60                    rts                            ;
1882 D3DB              ;
1883 D3DB              ;
1884 D3DB              gen_busy_err                            ;
1885 D3DB C2 20                 rep   #$20                     ;
1886 D3DD A9 15 00              lda   #gen_busy_error          ; generator already busy error
1887 D3E0 38                    sec                            ; mark an error
1888 D3E1 60                    rts                            ;
1889 D3E2              ;
1890 D3E2              ;
1891 D3E2              gen_err                                 ;
1892 D3E2 C2 20                 rep   #$20                     ;
1893 D3E4 A9 13 00              lda   #badgen                  ; invalid gen number
1894 D3E7 38                    sec                            ; mark an error
1895 D3E8 60                    rts                            ;
1896 D3E9              ;
1897 D3E9              ;
1898 D3E9              mode_err                                ;
1899 D3E9 C2 20                 rep   #$20                     ;
1900 D3EB A9 14 00              lda   #illmode                 ; generator mode error
1901 D3EE 38                    sec                            ; mark an error
1902 D3EF 60                    rts                            ;
1903 D3F0              ;
1904 D3F0              ;
1905 D3F0              irq_vect_err                            ;
1906 D3F0 C2 20                 rep   #$20                     ;
1907 D3F2 A9 17 00              lda   #mirq_error              ; master irq vector not assigned
1908 D3F5 38                    sec                            ; mark an error
1909 D3F6 60                    rts                            ;
1910 D3F7              ;
1911 D3F7              ;
1912 D3F7              *** dead code, 3-Dec-91 DAL
1913 D3F7              inv_buff_size                           ;
1914 D3F7 C2 20                 rep   #$20                     ;
1915 D3F9 A9 16 00              lda   #buff_siz_error          ; mark a DOC buffer size error
1916 D3FC 38                    sec                            ; mark an error
1917 D3FD 60                    rts                            ;
1918 D3FE              *** end of dead code
1919 D3FE              ;
1920 D3FE              ;
1921 D3FE              buff_siz_tbl                            ;
1922 D3FE 00 01                 DC W:$0100                     ; 256 bytes for $0
1923 D400 00 02                 DC W:$0200                     ; 512 bytes for $1
1924 D402 00 04                 DC W:$0400                     ; 1024 bytes for $2
1925 D404 00 08                 DC W:$0800                     ; 2048 bytes for $3
1926 D406 00 10                 DC W:$1000                     ; 4096 bytes for $4
1927 D408 00 20                 DC W:$2000                     ; 8192 bytes for $5
1928 D40A 00 40                 DC W:$4000                     ; 16384 bytes for $6
1929 D40C 00 80                 DC W:$8000                     ; 32768 bytes for $7
1930 D40E              ;
1931 D40E              ;
1932 D40E                       TITLE 'Fill Doc ram buffers' 
1933 D40E                       EJECT 
1934 D40E              ********************************************************
1935 D40E              *
1936 D40E              * Setup.doc.ram: This routine will fill the DOC ram buffers for OSC N &
1937 D40E              *                osc. N+1.
1938 D40E              *
1939 D40E              *     Import: e=0, m=0, x=0
1940 D40E              *             (gcb.gen) = generator number
1941 D40E              *             (gcb.wave.pos) = System ram wave position
1942 D40E              *             (gcb.wave.count) = number of waveform byte in sys ram
1943 D40E              *             (gcb.o0.start) = start of DOC buffer for osc. N
1944 D40E              *             (gcb.doc.count) = number of bytes in DOC buffer
1945 D40E              *
1946 D40E              ********************************************************
1947 D40E              ;
1948 D40E              ;
1949 D40E                       LONGA ON                       ;
1950 D40E                       LONGI ON                       ;
1951 D40E
1952 D40E              setup_doc_ram  
1953 D40E C2 30                 rep   #$30                     ;
1954 D410 A0 00 00              ldy   #$0000                   ; clear index register
1955 D413 98                    tya                            ; clear registers
1956 D414                       LONGA OFF                      ;
1957 D414 E2 20                 sep   #$20                     ;
1958 D416 DA                    phx                            ; save the gcb.index
1959 D417 B5 01                 lda   gcb_gen,x                ; get the generator number
1960 D419 29 0F                 and   #$0F                     ; remove channel info
1961 D41B AA                    tax                            ;
1962 D41C BF 5E CE FC           lda   >osctable,x              ; get the oscillator number
1963 D420 FA                    plx                            ; restore gcb index
1964 D421 48                    pha                            ;
1965 D422 85 F6                 sta   osc_num_temp             ; save oscillator number
1966 D424 A9 03                 lda   #$03                     ; mark a new wave, both oscs.
1967 D426 95 0F                 sta   gcb_new_wave,x           ;
1968 D428 20 AF D5              jsr   next_wave_chunk          ; move data for osc N
1969 D42B E2 20                 sep   #$20                     ;
1970 D42D 68                    pla                            ; get oscillator back
1971 D42E 1A                    inc   A                        ; next oscillator
1972 D42F 85 F6                 sta   osc_num_temp             ;
1973 D431 B5 00                 lda   gcb_mode,x               ; look for wave ended
1974 D433 10 35                 bpl   @1                       ;
1975 D435 C2 20                 rep   #$20                     ; 16 bits
1976 D437 B5 07                 lda   gcbp_ptr,x               ; next wave parameter pointer
1977 D439 15 08                 ora   gcbp_ptr+1,x             ;
1978 D43B D0 10                 bne   @2                       ;
1979 D43D C6 F6                 dec   osc_num_temp             ; go back to the even oscillator
1980 D43F 20 79 D4              jsr   set_doc_regs             ; init the registers
1981 D442                       LONGA On
1982 D442 A5 FA                 lda   SndFlags                 ; mark only one osc.
1983 D444 09 00 80              ora   #OneOscFlg               ; 
1984 D447 85 FA                 sta   SndFlags                 ;
1985 D449                       LONGA OFF                      ;
1986 D449 E2 20                 sep   #$20                     ;
1987 D44B 80 2B                 bra   @3                       ; go away
1988 D44D 20 74 D5     @2       jsr   set_pblock               ; more waves to follow
1989 D450 E2 20                 sep   #$20                     ;
1990 D452 34 00                 bit   gcb_mode,x               ; has wave ended
1991 D454 10 12                 bpl   @4                       ;
1992 D456 20 79 D4              jsr   set_doc_regs             ; initialize the DOC
1993 D459 C2 20                 rep   #$20                     ;
1994 D45B B5 07                 lda   gcbp_ptr,x               ; more waves after this?
1995 D45D 15 08                 ora   gcbp_ptr+1,x             ;
1996 D45F D0 07                 bne   @4                       ;
1997 D461 E2 20                 sep   #$20                     ;
1998 D463 A9 03                 lda   #$03                     ; no more waves after this
1999 D465 20 42 D6              jsr   sdoc_ctrl                ; make it quit
2000 D468              @4                                      ;
2001 D468 80 0E                 bra   @3                       ; go away
2002 D46A              @1                                      ;
2003 D46A 20 AF D5              jsr   next_wave_chunk          ; move data for osc N
2004 D46D                       LONGA On
2005 D46D C2 20                 rep   #$20                     ; 16 bits
2006 D46F A5 FA                 lda   SndFlags                 ; clear one oscillator marker
2007 D471 29 FF 7F              and   #clrOneOscFlg            ; 
2008 D474 85 FA                 sta   SndFlags                 ;
2009 D476                       LONGA OFF                      ;
2010 D476 E2 20                 sep   #$20                     ; 8 bits
2011 D478
2012 D478 60           @3       rts                            ; >>>--- exit setup.ram --->>>
2013 D479              ;
2014 D479              ;
2015 D479                       TITLE 'Setup DOC registers routine' 
2016 D479                       EJECT 
2017 D479              ********************************************************
2018 D479              *
2019 D479              * Set.DOC.regs: This routine will set up the DOC to run as a FF synth.
2020 D479              *               it sets up the frequency, control registers table size
2021 D479              *               & resolution bits in the DOC.
2022 D479              *
2023 D479              *     Import: A = oscillator number
2024 D479              *             (gcb.doc.siz)  number of pages code ($00-$07)
2025 D479              *             (gcb.o0.start) oscillator N start address
2026 D479              *             (gcb.wave.freq) frequency for oscillator N & osc N+1
2027 D479              *
2028 D479              ********************************************************
2029 D479              ;
2030 D479              ;
2031 D479                       LONGA OFF                      ;
2032 D479                       LONGI OFF                      ;
2033 D479
2034 D479              Set_doc_regs                            ;
2035 D479 08                    php                            ;
2036 D47A 8B                    phb                            ; save data bank register
2037 D47B 86 F7                 stx   gcb_index_temp           ; save gcb index
2038 D47D                       LONGA OFF                      ;
2039 D47D                       LONGI OFF                      ;
2040 D47D E2 30                 sep   #$30
2041 D47F A9 E1                 lda   #sram_bank               ; set data bank register
2042 D481 48                    pha                            ;
2043 D482 AB                    plb                            ;
2044 D483 A9 00                 lda   #$00                     ; select DOC, no auto incr
2045 D485 0F CA 00 E1           ora   >irq_volume              ; include system volume
2046 D489 8D 3C C0              sta   sgctrl                   ; write to sound glu control
2047 D48C A0 0A                 ldy   #doc_buff_size           ; get size of DOC buffer
2048 D48E B7 F3                 lda   [tmp_pram_ptr],y         ;
2049 D490 29 07                 and   #$07                     ; lower three bits
2050 D492 0A                    asl   A                        ;
2051 D493 0A                    asl   A                        ;
2052 D494 0A                    asl   A                        ;
2053 D495 17 F3                 ora   [tmp_pram_ptr],y         ; form the size and resolution
2054 D497 EB                    xba                            ; save the data to write
2055 D498 A5 F6                 lda   osc_num_temp             ; get oscillator number
2056 D49A 18                    clc                            ;
2057 D49B 69 C0                 adc   #ebtr                    ; point to size resolution
2058 D49D AA                    tax                            ;
2059 D49E EB                    xba                            ; get value to write
2060 D49F 8E 3E C0              stx   sgadrl                   ; set register pointer
2061 D4A2 8D 3D C0              sta   sgdata                   ; write the byte
2062 D4A5 A9 00                 lda   #Efreqlo                 ; point to frequency reg
2063 D4A7 18                    clc                            ;
2064 D4A8 65 F6                 adc   osc_num_temp             ; point to low freq in oscillator N
2065 D4AA AA                    tax                            ; save reg
2066 D4AB A0 06                 ldy   #wave_freq               ; get low byte of frequency
2067 D4AD B7 F3                 lda   [tmp_pram_ptr],y         ; get the low byte of the freq.
2068 D4AF 8E 3E C0              stx   sgadrl                   ; set register pointer
2069 D4B2 8D 3D C0              sta   sgdata                   ; write the byte
2070 D4B5 A9 20                 lda   #Efreqhi                 ; point to high freq reg
2071 D4B7 18                    clc                            ;
2072 D4B8 65 F6                 adc   osc_num_temp             ;
2073 D4BA AA                    tax                            ;
2074 D4BB A0 07                 ldy   #wave_freq+1             ; high byte of frequency
2075 D4BD B7 F3                 lda   [tmp_pram_ptr],y         ;
2076 D4BF 8E 3E C0              stx   sgadrl                   ; set register pointer
2077 D4C2 8D 3D C0              sta   sgdata                   ; write the byte
2078 D4C5 A9 40                 lda   #Evol                    ; point DOC volume register
2079 D4C7 18                    clc                            ;
2080 D4C8 65 F6                 adc   osc_num_temp             ;
2081 D4CA AA                    tax                            ;
2082 D4CB A0 10                 ldy   #doc_volume              ; get the volume setting
2083 D4CD B7 F3                 lda   [tmp_pram_ptr],y         ;
2084 D4CF F0 06                 beq   no_vol_change            ;
2085 D4D1 8E 3E C0              stx   sgadrl                   ; set register pointer
2086 D4D4 8D 3D C0              sta   sgdata                   ; write the byte
2087 D4D7 A9 80        no_vol_change lda   #Ewavpage           ; point to addr pointer
2088 D4D9 18                    clc                            ;
2089 D4DA 65 F6                 adc   osc_num_temp             ;
2090 D4DC A8                    tay                            ; save reg number
2091 D4DD A6 F7                 ldx   gcb_index_temp           ; get the gcb index back
2092 D4DF B5 0B                 lda   gcb_o0_start+1,x         ; get high byte of address
2093 D4E1 48                    pha                            ; save page
2094 D4E2 98                    tya                            ; get the oscillator number
2095 D4E3 6A                    ror   A                        ;
2096 D4E4 68                    pla                            ; get page number back
2097 D4E5 90 03                 bcc   even_osc                 ; if odd must bump start address
2098 D4E7 18                    clc                            ;
2099 D4E8 75 0D                 adc   gcb_doc_count+1,x        ; calc new page number
2100 D4EA              even_osc                                ;
2101 D4EA BB                    tyx                            ; get oscillator number back
2102 D4EB 8E 3E C0              stx   sgadrl                   ; set register pointer
2103 D4EE 8D 3D C0              sta   sgdata                   ; write the byte
2104 D4F1 A9 A0                 lda   #eocr                    ; point to the control register
2105 D4F3 18                    clc                            ;
2106 D4F4 65 F6                 adc   osc_num_temp             ;
2107 D4F6 48                    pha                            ; save data to write
2108 D4F7 A6 F7                 ldx   gcb_index_temp           ; get the gcb index
2109 D4F9 B5 01                 lda   gcb_gen,x                ; get the channel info
2110 D4FB 29 F0                 and   #$F0                     ;
2111 D4FD 09 0F                 ora   #$0F                     ; remove halt mode 4 (11)
2112 D4FF FA                    plx                            ; get new reg  number back
2113 D500 8E 3E C0              stx   sgadrl                   ; set register pointer
2114 D503 8D 3D C0              sta   sgdata                   ; write the byte
2115 D506 A6 F7                 ldx   gcb_index_temp           ; get gcb index back
2116 D508 AB                    plb                            ; restore data bank register
2117 D509 28                    plp                            ; restore status register
2118 D50A 60                    rts                            ; >>>--- exit set.doc.regs --->>>
2119 D50B
2120 D50B
2121 D50B              ********************************************************
2122 D50B              *
2123 D50B              * Fsynth.irq: This routine will service interrupts for the DOC free
2124 D50B              *             form synthesizer.
2125 D50B              *
2126 D50B              *     Import:
2127 D50B              *             (E100CC) = oscillator number generating irq.
2128 D50B              *
2129 D50B              *     Export: A, X, Y, D = same as entry
2130 D50B              *
2131 D50B              ********************************************************
2132 D50B              ;
2133 D50B              ;
2134 D50B              ;
2135 D50B
2136 D50B
2137 D50B                       LONGA OFF                      ;
2138 D50B                       LONGI OFF                      ;
2139 D50B
2140 D50B              Fsynth_irq  
2141 D50B 0B                    phd                            ; save direct register
2142 D50C AF B8 1D E1           lda   >sram_base+wap_addr+1    ; point to our work area
2143 D510 48                    pha                            ;
2144 D511 AF B7 1D E1           lda   >sram_base+wap_addr      ;
2145 D515 48                    pha                            ;
2146 D516 2B                    pld                            ;
2147 D517 AF CC 00 E1           lda   >osc_no_irq              ;
2148 D51B              nxt_osc_irq                             ;
2149 D51B E2 30                 sep   #$30                     ; native
2150 D51D 18                    clc                            ; no carry please
2151 D51E 6A                    ror   A                        ; put it in workable form
2152 D51F 29 1F                 and   #$1F                     ; 32 oscillators
2153 D521 85 F6                 sta   osc_num_temp             ; save the oscillator number
2154 D523 C9 1E                 cmp   #$1E                     ; check for oscillator 30-31
2155 D525 90 06                 bcc   not_apple                ; not apple reserved
2156 D527 22 5A D5 FC           jsl   apple_snd                ; will return through CLC, RTL
2157 D52B 80 10                 bra   chk_nxt_osc              ; check rest of oscillators
2158 D52D              not_apple                               ;
2159 D52D AA                    tax                            ; save the oscillator number
2160 D52E BF 6E CE FC           lda   >gentable,x              ; get generator number
2161 D532 AA                    tax                            ;
2162 D533 BF 8E CE FC           lda   >gcb_xlate,x             ; get the start addr of the gcb
2163 D537 AA                    tax                            ;
2164 D538 08                    php                            ; save status reg
2165 D539 20 5E D5              jsr   serve_gen                ;
2166 D53C 28                    plp                            ; restore status
2167 D53D              chk_nxt_osc                             ;
2168 D53D E2 20                 sep   #$20                     ;
2169 D53F AF CA 00 E1           lda   >irq_volume              ; select DOC no auto incr
2170 D543 8F 3C C0 E1           sta   gstatreg                 ;
2171 D547 A9 E0                 lda   #eoir                    ; read DOC irq register
2172 D549 8F 3E C0 E1           sta   gadrl                    ;
2173 D54D AF 3D C0 E1           lda   gdatreg                  ; read the DOC irq register
2174 D551 AF 3D C0 E1           lda   gdatreg                  ;
2175 D555 10 C4                 bpl   nxt_osc_irq              ; got a live one!!
2176 D557              exit_firq                               ;
2177 D557 2B                    pld                            ; restore direct register
2178 D558 18                    clc                            ; according to Peter
2179 D559 6B                    rtl                            ;
2180 D55A              ;
2181 D55A              ;
2182 D55A              apple_snd                               ;
2183 D55A 5C 48 01 E1           jmp   >asnd_vect               ; go to the Apple reserved vector
2184 D55E
2185 D55E
2186 D55E              ********************************************************
2187 D55E              *
2188 D55E              * Serve.gen: This routine will update the waveform pointers for a
2189 D55E              *            oscillator.
2190 D55E              *
2191 D55E              ********************************************************
2192 D55E
2193 D55E
2194 D55E                       LONGA OFF
2195 D55E                       LONGI OFF
2196 D55E
2197 D55E              serve_gen                               ; service oscillator irq
2198 D55E B5 00                 lda   gcb_tbl,x                ; get the mode byte
2199 D560 F0 47                 beq   exit_serve_gen           ; this one not in use
2200 D562
2201 D562 29 0F                 and   #$0F                     ; 4 bits of mode
2202 D564 C9 01                 cmp   #ffsynth_mode            ; is it our mode?
2203 D566 D0 42                 bne   other_mode               ; not ours pass control
2204 D568
2205 D568 B5 00                 lda   gcb_tbl,x                ; get the mode back
2206 D56A 10 43                 bpl   next_wave_chunk          ; waveform completed
2207 D56C
2208 D56C                       LONGA ON
2209 D56C
2210 D56C C2 20        chk_pblock rep   #$20                   ; check for another param block
2211 D56E B5 07                 lda   gcbp_ptr,x               ; get the pointer
2212 D570 15 08                 ora   gcbp_ptr+1,x
2213 D572 F0 2E                 beq   no_more_waves
2214 D574
2215 D574              set_pblock  
2216 D574 B5 00                 lda   gcb_mode,x               ; get the mode
2217 D576 29 7F FF              and   #$FF7F                   ; mask off wave ended bit
2218 D579 48                    pha                            ; save the mode & gen number
2219 D57A B5 09                 lda   gcbp_ptr+2,x             ; get next wave parameter pointers
2220 D57C 29 FF 00              and   #$00FF                   ; low byte only
2221 D57F 48                    pha                            ; save upper word of parameter block
2222 D580 B5 07                 lda   gcbp_ptr,x               ; get low word of parameter block
2223 D582 48                    pha   
2224 D583 A9 00 00              lda   #$0000                   ; reset mode byte & gen. number
2225 D586 95 00                 sta   gcb_mode,x
2226 D588 3B                    tsc                            ; get stack pointer
2227 D589 38                    sec   
2228 D58A E9 09 00              sbc   #$09                     ; cheat a bunch
2229 D58D 1B                    tcs   
2230 D58E
2231 D58E 20 3F D3              jsr   set_gcb                  ; set the generator control block
2232 D591
2233 D591 3B                    tsc                            ; get the stack pointer
2234 D592 18                    clc                            ;
2235 D593 69 0F 00              adc   #$0F                     ; put the stack back
2236 D596 1B                    tcs                            ; put the stack back
2237 D597
2238 D597                       LONGA OFF
2239 D597
2240 D597 E2 20                 sep   #$20
2241 D599 A9 03                 lda   #$03                     ; new wave/must set doc regs.
2242 D59B 95 0F                 sta   gcb_new_wave,x           ;
2243 D59D 20 AF D5              jsr   next_wave_chunk          ; move next block of wave
2244 D5A0 80 07                 bra   exit_serve_gen           ; keep going
2245 D5A2
2246 D5A2              no_more_waves  
2247 D5A2                       LONGA OFF
2248 D5A2
2249 D5A2 E2 20                 sep   #$20
2250 D5A4 A9 01                 lda   #$01                     ; halt this oscillator
2251 D5A6 20 42 D6              jsr   sdoc_ctrl                ; set the control byte in the DOC
2252 D5A9
2253 D5A9              exit_serve_gen  
2254 D5A9 60                    rts                            ; >>>--- exit serve.gen --->>>
2255 D5AA
2256 D5AA              other_mode                              ; user defined mode
2257 D5AA 22 BD 1D E1           jsl   sram_base+user_irq       ; call their handler
2258 D5AE 60                    rts                            ; all done with this one
2259 D5AF
2260 D5AF              next_wave_chunk  
2261 D5AF A9 60                 lda   #gptrinc+gramsel         ; select DOC ram with auto incr
2262 D5B1 0F CA 00 E1           ora   >irq_volume              ; include system volume
2263 D5B5 8F 3C C0 E1           sta   gstatreg
2264 D5B9 A5 F6                 lda   osc_num_temp             ; get the oscillator number
2265 D5BB
2266 D5BB                       LONGA ON
2267 D5BB                       LONGI ON
2268 D5BB
2269 D5BB C2 30                 rep   #$30
2270 D5BD 6A                    ror   A                        ; even or odd oscillator
2271 D5BE B5 0A                 lda   gcb_O0_start,x           ; get the DOC wave buffer start address
2272 D5C0 90 03                 bcc   set_even
2273 D5C2
2274 D5C2 18                    clc   
2275 D5C3 75 0C                 adc   gcb_doc_count,x          ; odd oscillator DOC buffer
2276 D5C5 8F 3E C0 E1  set_even sta   gadrl                    ; set DOC ram address
2277 D5C9 08                    php                            ; save micro status register
2278 D5CA B5 02                 lda   gcb_wave_pos,x           ; set source work pointer
2279 D5CC 85 F0                 sta   scratch                  ;
2280 D5CE B5 03                 lda   gcb_wave_pos+1,x
2281 D5D0 85 F1                 sta   scratch+1
2282 D5D2 B5 0C                 lda   gcb_doc_count,x          ; get the number of bytes to move
2283 D5D4 EB                    xba                            ; save number of pages to move
2284 D5D5 85 F8                 sta   page_count               ; save number of bytes to move
2285 D5D7 A0 00 00              ldy   #$0000                   ; reset work counter
2286 D5DA B5 05                 lda   gcb_wave_count,x         ; check for end of wave
2287 D5DC F0 21                 beq   wave_done
2288 D5DE
2289 D5DE E2 30        wave_mover sep   #$30                   ; 8 bits please
2290 D5E0
2291 D5E0              move_loop                               ;
2292 D5E0 B7 F0                 lda   [scratch],y              ; get a byte
2293 D5E2 8F 3D C0 E1           sta   gdatreg                  ; write it to the sound glu
2294 D5E6 C8                    iny   
2295 D5E7 D0 F7                 bne   move_loop                ; move one page
2296 D5E9 C2 20                 rep   #$20
2297 D5EB E6 F1                 inc   scratch+1                ; bump source pointer
2298 D5ED D6 05                 dec   gcb_wave_count,          ; decrement wave page count
2299 D5EF F0 0E                 beq   wave_done                ;
2300 D5F1
2301 D5F1 C6 F8                 dec   page_count               ; decr number pages to move
2302 D5F3 D0 E9                 bne   wave_mover
2303 D5F5 A5 F0                 lda   scratch                  ; set new wave start position
2304 D5F7 95 02                 sta   gcb_wave_pos,x
2305 D5F9 A5 F1                 lda   scratch+1
2306 D5FB 95 03                 sta   gcb_wave_pos+1,x
2307 D5FD 80 2B                 bra   exit_wave_mover          ; all done for this block
2308 D5FF
2309 D5FF              wave_done                               ;
2310 D5FF A5 F8                 lda   page_count               ; did we fill the DOC buffer?
2311 D601 3A                    dec   A
2312 D602 F0 0D                 beq   @1
2313 D604
2314 D604                       LONGA OFF
2315 D604                       LONGI OFF
2316 D604
2317 D604 E2 30                 sep   #$30
2318 D606 A9 00                 lda   #$00                     ; pad with 8 zeros
2319 D608 A0 40                 ldy   #$40                     ; need 64 zeroes
2320 D60A 8F 3D C0 E1  @2       sta   gdatreg
2321 D60E 88                    dey   
2322 D60F D0 F9                 bne   @2
2323 D611
2324 D611                       LONGA OFF
2325 D611
2326 D611              @1        
2327 D611 E2 20                 sep   #$20
2328 D613
2329 D613 A9 80        @4       lda   #$80                     ; mark wave done in mode byte
2330 D615 15 00                 ora   gcb_mode,x
2331 D617 95 00                 sta   gcb_mode,x
2332 D619 C2 20                 rep   #$20                     ; check for more waves
2333 D61B B5 07                 lda   gcbp_ptr,x
2334 D61D 15 08                 ora   gcbp_ptr+1,x
2335 D61F D0 09                 bne   exit_wave_mover          ; leave control alone if more waves to follow
2336 D621
2337 D621                       LONGA OFF
2338 D621
2339 D621 E2 20                 sep   #$20
2340 D623 A9 03                 lda   #03                      ; set to play & halt when done
2341 D625 20 42 D6              jsr   sdoc_ctrl                ; set control register
2342 D628 80 16                 bra   end_wave_move
2343 D62A
2344 D62A              exit_wave_mover  
2345 D62A                       LONGA OFF
2346 D62A
2347 D62A E2 20                 sep   #$20
2348 D62C A5 F6                 lda   osc_num_temp             ; get the oscillator number
2349 D62E 29 01                 and   #$01                     ; check for even or odd osc
2350 D630 18                    clc                            ; assume odd oscillator
2351 D631 D0 01                 bne   @1
2352 D633
2353 D633 38                    sec   
2354 D634              @1        
2355 D634 2A                    rol   A
2356 D635 35 0F                 and   gcb_new_wave,x           ; get the new wave marker
2357 D637 F0 07                 beq   end_wave_move
2358 D639 55 0F                 eor   gcb_new_wave,x           ; clear even/odd oscillator bit
2359 D63B 95 0F                 sta   gcb_new_wave,x           ; and save updated marker
2360 D63D 20 79 D4              jsr   set_doc_regs             ; setup doc registers
2361 D640
2362 D640              end_wave_move  
2363 D640 28                    plp                            ; restore micro status
2364 D641 60                    rts                            ; >>>--- exit wave.mover --->>>
2365 D642
2366 D642
2367 D642                       TITLE 'Shut oscillator off' 
2368 D642                       EJECT 
2369 D642              ********************************************************
2370 D642              *
2371 D642              * sdoc.ctrl: Sets the control register for a oscillator.
2372 D642              *
2373 D642              *     Import: AL = contents to write to osc. control reg.
2374 D642              *
2375 D642              ********************************************************
2376 D642              ;
2377 D642              ;
2378 D642
2379 D642              sdoc_ctrl  
2380 D642 48                    pha                            ; save control byte
2381 D643 A9 00                 lda   #00                      ; point to DOC no auto incr.
2382 D645 0F CA 00 E1           ora   >irq_volume              ; include system volume
2383 D649 8F 3C C0 E1           sta   gstatreg                 ;
2384 D64D 18                    clc   
2385 D64E A5 F6                 lda   osc_num_temp             ; get oscillator number
2386 D650 69 A0                 adc   #eocr                    ; point to control register
2387 D652 8F 3E C0 E1           sta   gadrl
2388 D656
2389 D656 68                    pla   
2390 D657 8F 3D C0 E1           sta   gdatreg                  ; write out control byte
2391 D65B 60                    rts                            ; >>>--- exit sdoc.ctrl --->>>
2392 D65C
2393 D65C
2394 D65C              ********************************************************
2395 D65C              *
2396 D65C              * Gen.ctrl.bytes: This call will read the control register for each
2397 D65C              *                of the oscillators corresponding to a generator.
2398 D65C              *
2399 D65C              *     Import: sp-9 = room for result
2400 D65C              *             sp-7 = generator number to read
2401 D65C              *
2402 D65C              ********************************************************
2403 D65C              ;
2404 D65C                       LONGA ON                       ;
2405 D65C                       LONGI ON                       ;
2406 D65C              ;
2407 D65C              Gen_ctrl_bytes                          ;
2408 D65C 08                    php                            ;
2409 D65D 78                    sei                            ; no interruptions
2410 D65E A3 08                 lda   $08,s                    ; get the generator number
2411 D660 C9 0F 00              cmp   #$000F                   ; check for valid generator
2412 D663 B0 43                 bcs   bad_generator            ; invalid generator number
2413 D665 AA                    tax                            ; get oscillator number
2414 D666 BF 5E CE FC           lda   >osctable,x              ;
2415 D66A 29 FF 00              and   #$00FF                   ;
2416 D66D 69 A0 00              adc   #$A0                     ; offset to control registers
2417 D670 AA                    tax                            ;
2418 D671 A8                    tay                            ; save oscillator number
2419 D672                       LONGA OFF                      ;
2420 D672 E2 20                 sep   #$20                     ;
2421 D674 22 11 CE FC           jsl   rdsreg                   ; read oscillator ctrl reg.
2422 D678 83 0A                 sta   $0A,s                    ; save the control byte
2423 D67A 22 1D CE FC           jsl   rdsnxt                   ; read the next oscillator
2424 D67E 29 01                 and   #$01                     ; save control byte
2425 D680 23 0A                 and   $0A,s                    ; must be 1 for wave to be ended
2426 D682 F0 19                 beq   @1                       ; wave ended
2427 D684 A2 08 00              ldx   #$08                     ; delay a minimum of 40 usecs.
2428 D687 CA           @3       dex                            ;
2429 D688 D0 FD                 bne   @3                       ; delay for a while
2430 D68A BB                    tyx                            ; get oscillator number back
2431 D68B 22 11 CE FC           jsl   rdsreg                   ; read oscillator ctrl reg.
2432 D68F 83 0A                 sta   $0A,s                    ; save the control byte
2433 D691 22 1D CE FC           jsl   rdsnxt                   ;
2434 D695 29 01                 and   #$01                     ; save control byte
2435 D697 23 0A                 and   $0A,s                    ; must be 1 for wave to be ended
2436 D699 F0 02                 beq   @1                       ; wave ended
2437 D69B A9 FF                 lda   #$FF                     ; wave has ended
2438 D69D 83 0A        @1       sta   $0A,s                    ;
2439 D69F 83 0B                 sta   $0B,s                    ;
2440 D6A1                       LONGA ON                       ;
2441 D6A1 28                    plp                            ; restore status register
2442 D6A2 A0 02 00              ldy   #2
2443 D6A5 4C B8 CB              jmp   Oendcall
2444 D6A8              bad_generator                           ;
2445 D6A8 28                    plp                            ;
2446 D6A9 A2 13 00              ldx   #badgen                  ; invalid generator number
2447 D6AC A0 02 00              ldy   #2                       ;
2448 D6AF 4C BE CB              jmp   oerrout                  ;
2449 D6B2
2450 D6B2                       ENDP 
2451 D6B2
2452 D6B2                       END   
